/*
	keditmask.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KEDITMASK_H
#define KEDITMASK_H

#include <qwidget.h>
#include <qlineedit.h>
#include <qdatetime.h>

/** Mostly used internaly as an abstract. If you want to create a
	*KEditMask with your own datatype you should use
	*this to inherit from.
	*@short Base class for defining a mask for KEditMask
	*@author Balzs Ternyi <terenyi@freemail.c3.hu>
	*@version 0.1
*/

class KEditMaskDefinition : public QObject
{
   Q_OBJECT
public:
	KEditMaskDefinition(QObject * parent=0, const char * name=0);
	~KEditMaskDefinition();
	
	bool setMask(QString p_mask);
	const QString* mask();

	const QString* validChars();
	const QString* dataFieldChars();
	
	virtual bool setData(QString* data_string, void* data_holder) = 0;
	virtual bool getData(const QString* data_string, void* data_holder) = 0;
	
	virtual bool isValid(const QString* data) = 0;
	virtual bool doMagic(const QString* input, QString* ref) = 0;
protected:
	void setValidChars(const QString chars);
	void setDataFieldChars(const QString chars);
	bool extractData(const QString* input, char mask_element, QString* ref);
	bool fillData(const QString* data, char mask_element, QString* ref);
signals:
	void definitionChanged();
private:
	QString qs_valid_chars;
	QString qs_datafield_chars;
	QString qs_mask;
};

/**
	*@short KEditMask definition for date input
	*@author Balzs Ternyi <terenyi@freemail.c3.hu>
	*@version 0.1
*/

class KEditMaskDefinitionDate : public KEditMaskDefinition
{
   Q_OBJECT
public:
	KEditMaskDefinitionDate(QObject * parent=0, const char * name=0, const char * p_mask=0);
	~KEditMaskDefinitionDate();
	
	virtual bool setData(QString* data_string, void* data_holder);
	virtual bool getData(const QString* data_string, void* data_holder);
	
	virtual bool isValid(const QString* data);
	virtual bool doMagic(const QString* input, QString* ref);
};

/**
	*@short KEditMask definition for time input
	*@author Balzs Ternyi <terenyi@freemail.c3.hu>
	*@version 0.1
*/

class KEditMaskDefinitionTime : public KEditMaskDefinition
{
   Q_OBJECT
public:
	KEditMaskDefinitionTime(QObject * parent=0, const char * name=0, const char * p_mask=0);
	~KEditMaskDefinitionTime();
	
	virtual bool setData(QString* data_string, void* data_holder);
	virtual bool getData(const QString* data_string, void* data_holder);
	
	virtual bool isValid(const QString* data);
	virtual bool doMagic(const QString* input, QString* ref);
};

/**
	*@short KEditMask definition for datetime input
	*@author Balzs Ternyi <terenyi@freemail.c3.hu>
	*@version 0.1
*/

class KEditMaskDefinitionDateTime : public KEditMaskDefinition
{
   Q_OBJECT
public:
	KEditMaskDefinitionDateTime(QObject * parent=0, const char * name=0, const char * p_mask=0);
	~KEditMaskDefinitionDateTime();
	
	virtual bool setData(QString* data_string, void* data_holder);
	virtual bool getData(const QString* data_string, void* data_holder);
	
	virtual bool isValid(const QString* data);
	virtual bool doMagic(const QString* input, QString* ref);
};

/**
	*@short KEditMask definition for fixed length numeric input
	*@author Balzs Ternyi <terenyi@freemail.c3.hu>
	*@version 0.1
*/

class KEditMaskDefinitionNumeric : public KEditMaskDefinition
{
   Q_OBJECT
public:
	KEditMaskDefinitionNumeric(QObject * parent=0, const char * name=0, const char * p_mask=0);
	~KEditMaskDefinitionNumeric();
	
	virtual bool setData(QString* data_string, void* data_holder);
	virtual bool getData(const QString* data_string, void* data_holder);
	
	virtual bool isValid(const QString* data);
	virtual bool doMagic(const QString* input, QString* ref);
};

/** Use this class to create an editline with a mask.
	*
	*It handles fix sized masks and the following datatypes:
	*date, time, datetime, numeric, userdefined.
	*
	*Simpe usage example:
	*<pre>
	*KEditMask *ke;
	*ke=new KEditMask(this,"",KEditMask::date);
	*ke->setGeometry(10,10,250,30);
	*ke->setMask("yyyy.mm.dd.");
	*ke->setData("1976.10.16.");
	*...
	*QDate d;
	*ke->getData(d);
	*</pre>
	*You don't have to use all of the subelements of a style. For example "yyyy/mm" is
	*also a possible mask.
	*@short A widget for getting user input in a predefined form
	*@author Balzs Ternyi <terenyi@freemail.c3.hu>
7	*@version 0.1
*/

// Lehet hogy a QString parametereket at kellene irni const char* -ra

class KEditMask : public QLineEdit
{
   Q_OBJECT
public: 
	KEditMask(QWidget *parent=0, const char *name=0);
	~KEditMask();
	
	void setMaskDefinition(KEditMaskDefinition* p_def);
	KEditMaskDefinition* maskDefinition();
	
	bool setData(void* ref);
	bool getData(void* ref);
protected:
	void tunePosition(int direction);
	bool isValidKey(QKeyEvent *e);
	void keyPressEvent(QKeyEvent *e);
protected slots:
	void slotDefinitionChanged();
private:
	KEditMaskDefinition *mask_definition;
};

#endif