/*
	postprocess.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef POSTPROCESS_H
#define POSTPROCESS_H

#include <qfileinfo.h>
#include <qstring.h>
#include <kprocess.h>
#include <qlist.h>
#include <qstrlist.h>

class PluginClient: public QObject
{
	Q_OBJECT
public:
	PluginClient(QString exec);
	~PluginClient();
	int start();
	int stop();
	QString info();
	QString defaults();
	bool isRunning();
	QString getDescription(QFileInfo* finfo);
protected slots:
	void slotProcessExited(KProcess* proc);
	void slotRecStdout(KProcess *proc,char *buffer,int buflen);
	void slotStdinWrote(KProcess *proc);
signals:
	void pluginDied();
protected:
	int prepareCommandLine(QString tmp);
	QString start_command;
	KProcess* kdcp;
	bool running;
	QString message;
	bool is_written;
};

class PluginData: public QObject
{
	Q_OBJECT
public:
	PluginData(QString pcommand,QString passoc,QString pfire);
	~PluginData();
	
	bool fetchDescription(QFileInfo* finfo,QDir* fdir,QString* desc);
	bool isDead();
	
	PluginClient* client;
protected slots:
	void slotPluginDied();
protected:
	bool started;
	bool dead;
	QString command;
	QStrList associations;	
	QStrList fire;
};

class PostProcess: public QObject
{
	Q_OBJECT
public:
	PostProcess();
	~PostProcess();
	QString getDescription(QFileInfo* finfo,QDir* fdir);
protected:
	void readConfig();
	QList<PluginData> plugins;
};

#endif



