/***************************************************************************
                          kduprocess.h  -  description
                             -------------------
    begin                : Thu Nov 25 1999
    copyright            : (C) 1999 by David Beattie
    email                : dbeattie@softhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDUPROCESS_H
#define KDUPROCESS_H

#include <qtextstream.h>
#include <qbuffer.h>
#include <qtimer.h>
#include <kprocess.h>
class KduView;
class KduViewItem;

/**
  *@author David Beattie
  */

class KDuProcess : private KProcess  {
	Q_OBJECT
public:
	KDuProcess(KduViewItem *attachto);
	~KDuProcess();
  /** Begin a "du" scan on the directory specified in the KduViewItem
	 * that has been attached to.
	 */
  virtual void start(void);

	void setShowFiles(bool show);
	bool showFiles(void);
  /** Tells this KDuProcess that another KDuProcess
has been started, rooted at *item.  This function
must only be called when it is known that
this KDuProcess is currently processing a
part of the tree which is underneath *item,
because its effect will be to cause the output
of "du" to be ignored until it has progressed
past the point where it would modify *item. */
  void ignoreUntilAfter(KduViewItem *item);

protected: // Protected methods
  /** Additional setup needed for "du" */
  int commSetupDoneC(void);

	bool filesflag;
  /**  */
  QString dirname;
  /** idle timer to process incoming "du" output between user-interfacing */
  QTimer *guiIdleTimer;
	
protected slots: // Protected slots
 	/** Gets the signals sent by "receivedStdout", processes the "du" output,
 	 *  transforming it into entries in a KTreeList.
 	 */
  void receiveStdout(KProcess *proc, char *buffer, int buflen);
  /**  */
  void receiveStderr(KProcess *proc, char *buffer, int buflen);
  /** process one line of the buffer */
  void processStdout(void);
  /** do end-of-useful-lifetime processing */

private:
	int treelistlevel;
  /**  */
	KduViewItem *lastInserted;
  /** per-process input buffer for QTextStream treatment of communication buffer. */
  QByteArray buffer;
	/** IO device for buffer */
	QBuffer bufferIO;
  /** QTextStream treatment of communication buffer. */
  QTextStream bufferStream;
  /** size of useful portion of buffer. */
  int buffersize;
	/** "current directory" --for use with stat */
	QString dudirroot;
  /** if ignoreUntilAfter(item) is called, this will
be set, and then the processing of
"du" output will no longer affect the tree
until after the treelistlevel becomes
equal to "ignoreUntilLevel", at which
time it can be stated that "item" has
been fully ignored, and processing can
be resumed. */
  int ignoreUntilLevel;
  /** keeps a record of what portion of the tree
we are attached to. */
  KduViewItem * attachedto;
private: // Private methods
  /**  */
  bool isDir(char const * const path);
};

#endif
