/***************************************************************************
                          kduview.cpp  -  description
                             -------------------
    begin                : Wed Nov 24 11:21:57 EST 1999
    copyright            : (C) 1999 by David Beattie
    email                : dbeattie@softhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qheader.h>

// application specific includes
#include "kduview.h"
#include "kduviewitem.h"
#include "kduprocess.h"
#include "kdu.h"
#include <assert.h>

KduView::KduView(QWidget *parent, const char *name) : QListView(parent, name)
{
	setRootIsDecorated(TRUE);
	KduViewItem *root = new KduViewItem(this,"/");
	root->setOpen(TRUE);
	KDuProcess *du = new KDuProcess(root);

	du->start();

/*	processes.push(du); */

/*	setExpandLevel(1); */

	connect(this, SIGNAL(currentChanged(QListViewItem *)), SLOT(onItemHighlight(QListViewItem *)));
	connect(this, SIGNAL(doubleClicked(QListViewItem *)), SLOT(onItemSelect(QListViewItem *)));
	connect(this, SIGNAL(returnPressed(QListViewItem *)), SLOT(onItemSelect(QListViewItem *)));

/*  setBackgroundMode(PaletteBase); */

	header()->hide();
	addColumn("");
	//following code lifted from KTreeList initializer
	switch(style()) {
		case WindowsStyle:
		case MotifStyle:
			setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
			break;
		default:
			setFrameStyle(QFrame::Panel | QFrame::Plain);
			setLineWidth(1);
	}
	setFocusPolicy(QWidget::StrongFocus);
}

KduView::~KduView()
{
}

void KduView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

  printpainter.end();
}

void KduView::onItemHighlight(QListViewItem *item)
{
	KduViewItem *kitem = (KduViewItem *) item;
	QString path;
	while(kitem)
		path.prepend(kitem->name()), kitem = kitem->parent();
	((KduApp *) parentWidget())->slotStatusMsg(path);
}

/**  */
void KduView::onItemSelect(QListViewItem *item)
{
	register KduViewItem *child = ((KduViewItem *)item)->firstChild();

	// if a "du" process is running to find the size of this element already
	if (((KduViewItem *)item)->isSizeUnknown()) {
		register KDuProcess *dp;
		register KduViewItem *parent = (KduViewItem *) item;
		// then find it.
		while (assert(parent), !(dp = parent->getDuProcess()))
			parent = parent->parent();
		// and tell it not to mess with anything in this subtree anymore.
		dp->ignoreUntilAfter((KduViewItem *)item);
	}

	while (child) {
		register KduViewItem *next = child->nextSibling();
		delete child;
		child = next;
	}

	item->setOpen(TRUE);
	KDuProcess *newDu = new KDuProcess((KduViewItem *)item);
	newDu->setShowFiles(TRUE);
	newDu->start();
}

/** display optimization on resizeContents.
Calling viewport()->update() is not necessary
when resizing contents of a KduView, because
every time that the size of the contents will change,
another paint event is being generated, by the
invalidateHeight() function call, from within
QListViewItem::setOpen() (see QT source code)
Thus, we disable updates during the
QListview::resizeContents() function call,
saving ourselves a couple screen flashes. */
void KduView::resizeContents(int w, int h)
{
	QWidget *V = viewport();
	bool v = V->isUpdatesEnabled();
	V->setUpdatesEnabled(FALSE);
	QListView::resizeContents(w,h);
	V->setUpdatesEnabled(v);
}

/** reimplemented for display optimization
purposes.  The default implementation in
QListView's source code (David Beattie:
"I checked source code versions 1.44 and
2.0 of qt") triggers two different kinds of
updates.  First, calling item->setOpen triggers
an update using triggerUpdate() if the item is
visible.  Second, QListView's setOpen adds
to that making the updated item "dirty", and
starting the dirtyItemTimer.  And because these
two kinds of updates are triggered in that order,
and thus the timers for them go off in that order
(so dirtyItemTimer's handler cannot sense that
the normal updateContents handler for triggerUpdate
has been run as well), then we get more updating
than we need. */
void KduView::setOpen(QListViewItem *item, bool open)
{
	item->setOpen(open);
}
