/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include "info.h"
#include "kdfree.h"

KDFree::~KDFree(){
}

KDFree::KDFree(QWidget *parent, const char *name, bool modal, KDConfig *cfg):QTabDialog(parent,name){
	config=cfg;

	summary=new Summary(this);
	timer=new QTimer(this);
	timer->start(config->update_freq*1000,false);

	configWidget=new KDConfigWidget(0,"KDFree Configuration",config);
	buttonConfig=new QPushButton(this);
	buttonConfig->setText(klocale->translate("Configuration"));

	pagelist.setAutoDelete(true);

	setOkButton(NULL);
	setDefaultButton(klocale->translate("Update"));
	setApplyButton(klocale->translate("Help"));
	setCancelButton(klocale->translate("Close"));

	connect(buttonConfig,SIGNAL(clicked()),SLOT(slot_config()));
	connect(configWidget,SIGNAL(newConfig()),SLOT(slot_newCfg()));
	connect(this,SIGNAL(applyButtonPressed()),SLOT(slot_help()));
	connect(this,SIGNAL(defaultButtonPressed()),SLOT(slot_updateDialog()));
	connect(this,SIGNAL(cancelButtonPressed()),SLOT(slot_close()));
	connect(timer,SIGNAL(timeout()),SLOT(slot_updateDialog()));
	connect(summary,SIGNAL(selected(int)),SLOT(slot_summarySelected(int)));

	resize(500,370);
	setMinimumSize(size());

	FILE *mountfile;
	char device[1000];
	char mountpoint[1000];
	char dummy[1000];

	mountfile=fopen("/etc/fstab","r");
	setvbuf(mountfile,NULL,_IONBF,0);
	rewind(mountfile);

	addTab(summary,klocale->translate("Summary"));
	while(fscanf(mountfile, "%s %s %s", device, mountpoint,dummy)!=EOF){
		if ((QString(device).right(4)!="proc")&&
		    (QString(device).right(3)!="pts")&&
		    (QString(mountpoint).left(1)=="/")){
			pagelist.append(new Page(this,new diskData(mountpoint,config),config));
			addTab(pagelist.last(),mountpoint);
			connect(pagelist.last(),SIGNAL(supdate(diskData *)),SLOT(slot_supdate(diskData *)));
		}
	}
	addTab(new Info(this),klocale->translate("Info"));

	fclose(mountfile);
	slot_updateDialog();	

}

void KDFree::slot_close(){
	config->save();
	kapp->quit();
}

void KDFree::slot_help(){
	KApplication::getKApplication()->invokeHTMLHelp("kdu/kdfree.html","");
}

void KDFree::slot_updateDialog(){
	summary->liste->clear();
	for (Page *p=pagelist.first(); p!=0;p=pagelist.next()) p->update();
}

void KDFree::slot_supdate(diskData *dd){
	summary->addDrive(dd);
}

void KDFree::slot_summarySelected(int num){
	showPage(pagelist.at(num));
}

void KDFree::slot_config(){
	configWidget->show();
}

void KDFree::slot_newCfg(){
	timer->changeInterval(config->update_freq*1000);
	for (Page *p=pagelist.first(); p!=0;p=pagelist.next()) p->newConfig();
}

void KDFree::resizeEvent(QResizeEvent *){
	buttonConfig->setGeometry(10,height()-31,100,25);
}

int main(int argc,char *argv[]){
 	KApplication 	*thisapp=new KApplication(argc,argv,"kdfree");
	KDConfig	*config;
	KDFree 		*main;
	int		retstat;

	config=new KDConfig();
	config->path=argv[1];
 
	main=new KDFree(NULL,NULL,false,config); 

	thisapp->setTopWidget(main);
	thisapp->setMainWidget(main);

	main->show();
	retstat=thisapp->exec();
	config->save();
	delete(config);

	return retstat;
}
