/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.4                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#include "page.h"

#include <qbrush.h>
#include <qpainter.h>

Page::~Page(){
}

Page::Page(QWidget *parent, diskData *d, KDConfig *cfg):QWidget (parent){
	dd=d;
	config=cfg;

	qlabel_disksymbol=new QLabel(this);
	qlabel_diskname=new QLabel(this);
	qlabel_disktyp=new QLabel(this);
	qlabel_usedmem=new QLabel(this);
	qlabel_freemem=new QLabel(this);
	qlabel_header=new QLabel(this);
	qlabel_usedmemi=new QLabel(this);
	qlabel_freememi=new QLabel(this);
	qlabel_grafik=new QLabel(this);
	qlabel_diskinfo=new QLabel(this);
	button_openURL=new QPushButton(klocale->translate("Go to Location"),this);
	kfm=new KFM();
	kicl=new KIconLoader();

	qlabel_disksymbol->setText(klocale->translate("Couldnt load icon!"));
	qlabel_disksymbol->setAlignment( AlignCenter );

	qlabel_usedmemi->setBackgroundColor(config->color_disk_free);
	qlabel_freememi->setBackgroundColor(config->color_disk_full);

	setMinimumSize(300,250);

	update();

	connect(button_openURL,SIGNAL(clicked()),SLOT(slot_openURL()));
}

void Page::slot_openURL(){
	if (kfm->isKFMRunning()) kfm->openURL("file:"+dd->mountpoint);
}


void Page::paintEvent(QPaintEvent *){
	QPainter p;  
	QBrush bblue;
	QBrush bred;
	int a2,a1;

	if (dd->ismounted){
		a2=(int)(5760*dd->disk_used/dd->disk_capacity);
		a1=5760-a2;
	}else{
		a2=0;
		a1=5760;
	}

	p.begin(qlabel_grafik);

	bred.setColor(config->color_disk_full);
	bred.setStyle(SolidPattern);
	bblue.setStyle(SolidPattern);
	bblue.setColor(config->color_disk_free);

	p.setPen(config->color_disk_full);
	for (int i=0;i<16;i++) p.drawArc(16,3+i,119,30,0,a1);
	p.setPen(config->color_disk_free);
	for (int i=0;i<16;i++) p.drawArc(16,3+i,119,30,0,-a2);
	p.setPen(black);
	for (int i=0;i<16;i++) p.drawArc(16,3+i,119,30,a1,0);
	p.setBrush(bred);
	p.drawPie(15,3,120,30,0,a1);
	p.setBrush(bblue);
	p.drawPie(15,3,120,30,0,-a2);
	p.drawArc(15,18,120,30,0,-2880);
	p.drawLine(15,18,15,33);
	p.drawLine(134,18,134,33); 
	p.end();
}

void Page::resizeEvent(QResizeEvent *){
	qlabel_disksymbol->setGeometry(30,30,32,32);
	qlabel_diskname->setGeometry(92,30,width()-112,15);
	qlabel_disktyp->setGeometry(92,47,width()-112,15);
	qlabel_usedmemi->setGeometry(30,100,15,15);
	qlabel_freememi->setGeometry(30,120,15,15);
	qlabel_usedmem->setGeometry(50,100,width()-200,15);
	qlabel_freemem->setGeometry(50,120,width()-200,15);
	qlabel_header->setGeometry(30,140,width()-50,15);
	qlabel_grafik->setGeometry(width()-160,100,150,55);

	button_openURL->setGeometry(width()-140,200,130,30);
	qlabel_diskinfo->setGeometry(30,180,width()-200,100);
}

QString Page::fitSize(float s, bool c){
	char einheit[6]="Bytes";
	char result[300]="";

	if (c){
		if (s>1000){
			s=s/1024;
			einheit="Kb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Mb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Gb   ";
		}
		sprintf(result,"%.2f %s",s,einheit);	
	}else{
		sprintf(result,"%.2f",s);	
	}

	QString tmp=result;
	if (tmp.right(3)==".00") tmp=tmp.left(tmp.length()-3);
	return tmp;
}

void Page::update(){
	dd->update();
	if (dd->ismounted){
		qlabel_diskname->setText(klocale->translate("Device: ")+dd->devicename);
		qlabel_disktyp->setText(klocale->translate("Device-Typ: ")+dd->filesystem);
		qlabel_usedmem->setText(klocale->translate("Used Memory: ")+fitSize(+dd->disk_used,true)+" ( "+fitSize((+dd->disk_used*100/+dd->disk_capacity),false)+"% )");
		qlabel_freemem->setText(klocale->translate("Free Memory: ")+fitSize(+dd->disk_capacity-+dd->disk_used,true)+" ( "+fitSize(((+dd->disk_capacity-+dd->disk_used)*100/+dd->disk_capacity),false)+"% )");
		qlabel_header->setText(klocale->translate("Capacity: ")+fitSize(+dd->disk_capacity,true));
		qlabel_diskinfo->setText(klocale->translate("Device: ")+dd->devicename+"\n"
				 +klocale->translate("Mounted on: ")+dd->mountpoint+"\n"
				 +klocale->translate("FS-Type: ")+dd->filesystem+"\n"
				 +klocale->translate("Blocks: ")+dd->disk_blocks+"\n"
				 +klocale->translate("Blocksize: ")+dd->disk_bl_size+"\n"
				 +klocale->translate("Options: ")+dd->readwrite);

		QString ic="blockdevice.xpm";

		qlabel_disksymbol->setPixmap(kicl->loadIcon(dd->icon));
		qlabel_disksymbol->repaint();
		button_openURL->setEnabled(true);
	}else{
		qlabel_diskname->setText(klocale->translate("Device: Not mounted"));
		qlabel_disktyp->setText(klocale->translate("Device-Typ: "));
		qlabel_usedmem->setText(klocale->translate("Used Memory: "));
		qlabel_freemem->setText(klocale->translate("Free Memory: "));
		qlabel_header->setText(klocale->translate("Capacity: "));
		qlabel_diskinfo->setText(klocale->translate("Device: \nMounted on: \nFS-Type: \nBlocks: \nBlocksize: \nOptions: \n"));

		QString ic="blockdevice.xpm";

		qlabel_disksymbol->setPixmap(kicl->loadIcon(dd->icon));
		qlabel_disksymbol->repaint();
		button_openURL->setEnabled(false);		

	}
	emit(supdate(dd));
	repaint();
}

void Page::newConfig(){
	qlabel_usedmemi->setBackgroundColor(config->color_disk_free);
	qlabel_freememi->setBackgroundColor(config->color_disk_full);
	dd->update();
	qlabel_disksymbol->setPixmap(kicl->loadIcon(dd->icon));
}
