/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#ifndef PAGE_H
#define PAGE_H

#include "diskdata.h"
#include "kdconfig.h"

#include <kapp.h>
#include <kfm.h>
#include <kiconloader.h>

#include <qlabel.h>
#include <qpushbt.h>

class Page:public QWidget{
	Q_OBJECT
public:
	Page(QWidget *parent=0, diskData *sum=0, KDConfig *cfg=0);
	~Page();
	void 			resizeEvent(QResizeEvent *);
	void 			getDiskValues();
	void 			update();
	void 			newConfig();
	QString			fitSize(float s,bool c);
	QString			path;

private:
	QLabel			*qlabel_disksymbol;
	QLabel			*qlabel_diskname;
	QLabel			*qlabel_disktyp;
	QLabel			*qlabel_usedmem;
	QLabel			*qlabel_freemem;
	QLabel			*qlabel_header;
	QLabel			*qlabel_usedmemi;
	QLabel			*qlabel_freememi;
	QLabel			*qlabel_grafik;
	QLabel			*qlabel_diskinfo;
	QPushButton		*button_openURL;
	diskData		*dd;
	KFM			*kfm;
	KDConfig		*config;
	KIconLoader		*kicl;

private slots:
	void paintEvent(QPaintEvent *);
	void slot_openURL();

signals:
	void supdate(diskData *dd);
};

#endif PAGE_H

