/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Usage V0.9.5                                             *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@wilhelmshaven-online.de                            *
 *                                                                       *
 *************************************************************************/

#include <qdir.h>
#include <qpainter.h>

#include <kfiledialog.h>
#include <kmsgbox.h>

#include <sys/stat.h>
#include <sys/vfs.h>
#include <unistd.h>

#include "kdu.h"

QString fitSize(float s, bool c){
	char einheit[6]="Bytes";
	char result[300]="";

	if (c){
		if (s>1000){
			s=s/1024;
			einheit="Kb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Mb   ";
		}
		if (s>1000){
			s=s/1024;
			einheit="Gb   ";
		}
		sprintf(result,"%.2f %s",s,einheit);	
	}else{
		sprintf(result,"%.2f",s);	
	}

	QString tmp=result;
	if (tmp.right(3)==".00") tmp=tmp.left(tmp.length()-3);
	return tmp;
}


KDuDialog::~KDuDialog(){
	cancel=true;
	writeSettings();
}

KDuDialog::KDuDialog(KApplication *ta):QDialog(0,0){
	thisapp=ta;
	readSettings();
	setMinimumWidth(550);
	setMinimumHeight(320);

	output=new KTabListBox (this,"K Disk Usage Main Output",5,2);
	output->clearTableFlags(Tbl_hScrollBar);
	output->setTableFlags(Tbl_autoHScrollBar);
	output->setTableFlags(Tbl_autoVScrollBar);
	output->setSeparator('\n');
	output->setColumn(0, klocale->translate("User"), 2);
	output->setColumn(1, klocale->translate("Groupe"),2);
	output->setColumn(2, klocale->translate("Size"),  2);
	output->setColumn(3, klocale->translate("Name"),  2);
	output->setColumn(4, klocale->translate("Date"),  2);

	wholesize=new QLabel(this);
	verzeichnis=new QLabel(this);
	verzeichnis->setText(klocale->translate("Directory:"));
	chgdir=new QPushButton(this);
	chgdir->setText(klocale->translate("Change Directory"));
	stopdu=new QPushButton(this);
	stopdu->setText(klocale->translate("Stop"));

	eingabe=new QLineEdit(this);
	
	file = new QPopupMenu;
	CHECK_PTR( file );
	file->insertItem(klocale->translate("Change &Directory"),this, SLOT(changeDir()),0);
	file->insertItem(klocale->translate("&Close"),this, SLOT(closeClicked()),0);

	settings = new QPopupMenu;
	CHECK_PTR(settings);
	settings->setCheckable(true);
	settings->insertItem(klocale->translate("User"),this, SLOT(setUser()),0);
	settings->insertItem(klocale->translate("Groupe"),this, SLOT(setGroup()),0);
	settings->insertItem(klocale->translate("Size"),this, SLOT(setSize()),0);
	settings->insertItem(klocale->translate("Name"),this, SLOT(setName()),0);
	settings->insertItem(klocale->translate("Date"),this, SLOT(setDate()),0);
	settings->insertSeparator();
	settings->insertItem(klocale->translate("Hidden Dirs"),this, SLOT(setHiddenDirs()),0);
	settings->insertItem(klocale->translate("Hidden Files"),this, SLOT(setHiddenFiles()),0);

	settings->setItemChecked(settings->idAt(0),set_user);
	settings->setItemChecked(settings->idAt(1),set_user);
	settings->setItemChecked(settings->idAt(2),set_size);
	settings->setItemChecked(settings->idAt(3),set_name);
	settings->setItemChecked(settings->idAt(4),set_date);
	settings->setItemChecked(settings->idAt(6),set_hidden_dirs);
	settings->setItemChecked(settings->idAt(7),set_hidden_files);



	QPopupMenu *help = new QPopupMenu;
	CHECK_PTR( help );
	help->insertItem( klocale->translate("&Help"),this, SLOT(slotHelp()) );
	help->insertSeparator();
	help->insertItem( klocale->translate("&About..."), this, SLOT(slotAbout()) );

	menu = new KMenuBar( this );
	CHECK_PTR( menu );

	menu->insertItem( klocale->translate("&File"), file );
	menu->insertItem( klocale->translate("&Settings"), settings );
	menu->insertSeparator();
	menu->insertItem( klocale->translate("&Help"), help );
	menu->show();

	connect(chgdir,SIGNAL(clicked()),SLOT(changeDir()));
	connect(stopdu,SIGNAL(clicked()),SLOT(slot_stopdu()));
	connect(eingabe,SIGNAL(returnPressed()),SLOT(returnPressed()));
	connect(menu,SIGNAL(moved(menuPosition)),SLOT(menuMoved()));
}

void KDuDialog::closeClicked(){
	writeSettings();
	kapp->quit();
}

void KDuDialog::changeDir(){
	KDirDialog *dird;
	dird=new KDirDialog(path,this,"MyDialog");
	if (dird->exec()) setPath(dird->dirPath());
	delete(dird);
}

void KDuDialog::slotHelp(){
	KApplication::getKApplication()->invokeHTMLHelp("kdu/kdu.html","");
}

void KDuDialog::slotAbout(){
	KMsgBox	*about;
	about=new KMsgBox (this,"About KDu",	klocale->translate("KDu - KDisk Usage V0.9.5\n\n"
						"Written by Christian Poulter (virtual-dynamics@gmx.net)\n"
						"Copyright (c) 1998-99 by Christian Poulter\n\n"
						"This program is free software; you can redistribute it and/or modify\n"
						"it under the terms of the GNU General Public License as published by\n"
						"the Free Software Foundation - version 2.\n\n"
						"This program is distributed in the hope that it will be useful,\n"
						"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
						"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
						"GNU General Public License in file COPYING for more details.\n\n"
						"Have a lot of Fun!\n")
			,KMsgBox::INFORMATION,"Ok");
	about->show();
}

void KDuDialog::returnPressed(){
	QString st=eingabe->text();

	if (st.length()>0) setPath(st);
}

void  KDuDialog::setUser(){
	if (set_group||set_size||set_name||set_date){
		set_user=!set_user;
		settings->setItemChecked(settings->idAt( 0 ), set_user );	
		setColumns();
	}
}

void  KDuDialog::setGroup(){
	if (set_user||set_size||set_name||set_date){
		set_group=!set_group;
		settings->setItemChecked(settings->idAt( 1 ), set_group );
		setColumns();
	}
}

void  KDuDialog::setSize(){
	if (set_group||set_user||set_name||set_date){
		set_size=!set_size;
		settings->setItemChecked(settings->idAt( 2 ), set_size );
		setColumns();
	}
}

void  KDuDialog::setName(){
	if (set_group||set_size||set_user||set_date){
		set_name=!set_name;
		settings->setItemChecked(settings->idAt( 3 ), set_name );
		setColumns();
	}
}

void  KDuDialog::setDate(){
	if (set_group||set_size||set_name||set_user){
		set_date=!set_date;
		settings->setItemChecked(settings->idAt( 4 ), set_date );
		setColumns();
	}
}

void  KDuDialog::setHiddenDirs(){
	set_hidden_dirs=!set_hidden_dirs;
	settings->setItemChecked(settings->idAt( 6 ), set_hidden_dirs );
}

void  KDuDialog::setHiddenFiles(){
	set_hidden_files=!set_hidden_files;
	settings->setItemChecked(settings->idAt( 7 ), set_hidden_files );
}


void KDuDialog::setColumns(){
	int count=1;
	int a,b,c,d,e,w;

	w=output->width()-10;

	if (set_user==true)  {count+= 20;a= 20;} else a=0;
	if (set_group==true) {count+= 20;b= 20;} else b=0;
	if (set_size==true)  {count+= 30;c= 30;} else c=0;
	if (set_name==true)  {count+=110;d=110;} else d=0;
	if (set_date==true)  {count+= 60;e= 60;} else e=0;

	output->setColumnWidth(0,w*a/count);
	output->setColumnWidth(1,w*b/count);
	output->setColumnWidth(2,w*c/count);
	output->setColumnWidth(3,w*d/count);
	output->setColumnWidth(4,w*e/count);
	
	output->repaint();
}

void KDuDialog::menuMoved(){
	if (menu->menuBarPos()!=KMenuBar::Floating){
		output->setGeometry(20,40,width()-40,height()-120);
		menu->resize(width(),menu->height());
	}else
		output->setGeometry(20,20,width()-40,height()-100);
}

void KDuDialog::resizeEvent(QResizeEvent *){
	menuMoved();
	setColumns();
	wholesize->setGeometry(20,height()-80,width()-140,30);
	chgdir->setGeometry(width()-190,height()-40,150,30);
	stopdu->setGeometry(width()-90,height()-70,50,20);
	verzeichnis->setGeometry(20,height()-40,70,30);
	eingabe->setGeometry(110,height()-40,width()-310,30);
}

void KDuDialog::setPath(QString p){
	path=p;
	makeDu();
}	

void KDuDialog::makeDu(){
	unsigned long size=0;

	chgdir->setEnabled(false);	
	eingabe->setEnabled(false);
	stopdu->setEnabled(true);
	menu->setItemEnabled(0,false);
	menu->setItemEnabled(1,false);
	menu->setItemEnabled(3,false);
	menu->repaint();
	
	QString name=path;
	cancel=false;
	eingabe->setText(name);
	if ((name.right(1).at(0)==QDir::separator())&&(name.length()>1)) name=name.left(name.length()-1);
	output->clear();
	QDir d(name);
	if (d.exists()){
		files=0;dirs=0;
		output->setAutoUpdate(FALSE);
		size=readDir(name);
		wholesize->setText(klocale->translate("Size of ")+name+": "+fitSize(size,true).stripWhiteSpace()+", "+fitSize(files,false)+klocale->translate(" File(s), ")+fitSize(dirs,false)+klocale->translate(" Directory(s)"));
		output->setAutoUpdate(TRUE);
	}else{
		wholesize->setText(klocale->translate("Could not access Directory!"));
	}
	output->repaint();

	stopdu->setEnabled(false);
	eingabe->setEnabled(true);
	chgdir->setEnabled(true);
	menu->setItemEnabled(0,true);
	menu->setItemEnabled(1,true);
	menu->setItemEnabled(3,true);
	menu->repaint();
}

unsigned long fileSize(QString file){
	struct stat filestat;
	long int	size=-1;
	if (stat(file.data(),&filestat)==0) size=filestat.st_size;

	return size;
}

unsigned long KDuDialog::readDir(QString name){
	unsigned long dirsize=0;
	QDir d1,d2;

	d1.setPath(name);
	if (set_hidden_dirs) d1.setFilter(QDir::Dirs|QDir::Hidden); else d1.setFilter(QDir::Dirs);
	d1.setSorting( QDir::Name );
	d1.setNameFilter("*");

	d2.setPath(name);
	if (set_hidden_files) d2.setFilter(QDir::Files|QDir::Hidden|QDir::Drives); else d2.setFilter(QDir::Files|QDir::Drives);
	d2.setSorting( QDir::Name );
	d2.setNameFilter("*");

	if (d1.isReadable()){
		const QFileInfoList *list=d1.entryInfoList();
		QFileInfoListIterator it(*list);
		QFileInfo *fi;
		char st[250];

		wholesize->setText(klocale->translate("Processing dir ")+name);
		thisapp->processEvents();	
		output->repaint();

		if (!cancel) {

			while ( (fi=it.current()) ) {
				QString tmp=fi->fileName();

				if (tmp=="."){
					dirsize+=fi->size();
				}else if(tmp==".."){
				}else{
					if (!fi->isSymLink()){
						unsigned long sz=0;
	
						if (!cancel) sz=readDir(name+"/"+tmp);
						dirsize+=sz;
						sprintf(st,"%s \n %s \n %s \n %s/%s/ \n %s",fi->owner(),fi->group(),fitSize(fi->size(),true).data(),name.data(),fi->fileName().data(),fi->lastModified().toString().data());
						output->insertItem(st);
						dirs++;

					}
				}
				++it;
			}

			list=d2.entryInfoList();
			QFileInfoListIterator it2(*list);

			while ( (fi=it2.current()) ) {
				long int size=fileSize(fi->filePath());
				QString size_string=klocale->translate("Error stating file!");
				if (size!=-1) size_string=fitSize(size,true);
				dirsize+=fi->size();
				sprintf(st,"%s \n %s \n %s \n %s/%s \n %s",fi->owner(),fi->group(),size_string.data(),name.data(),fi->fileName().data(),fi->lastModified().toString().data());
		
				++it2;
				output->insertItem(st);
				files++;
			}
		}
	}else{
		dirsize=0;
		output->insertItem(" \n \n "+QString(klocale->translate("no access to"))+" \n "+name+" \n \n");
	}

	return dirsize;
}

void KDuDialog::readSettings(){
	QString entry;

	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();
	config->setGroup("View");

	entry = "yes";
	if ( config->readEntry("User", entry) == entry)
		set_user=true;
	else
		set_user=false;

	entry = "yes";
	if ( config->readEntry("Group", entry) == entry)
		set_group=true;
	else
		set_group=false;

	entry = "yes";
	if ( config->readEntry("Size", entry) == entry)
		set_size=true;
	else
		set_size=false;

	entry = "yes";
	if ( config->readEntry("Name", entry) == entry)
		set_name=true;
	else
		set_name=false;

	entry = "yes";
	if ( config->readEntry("Date", entry) == entry)
		set_date=true;
	else
		set_date=false;

	entry = "yes";
	if ( config->readEntry("Hidden_Dirs", entry) == entry)
		set_hidden_dirs=true;
	else
		set_hidden_dirs=false;

	entry = "yes";
	if ( config->readEntry("Hidden_Files", entry) == entry)
		set_hidden_files=true;
	else
		set_hidden_files=false;

	resize(config->readNumEntry("WindowWidth",450),config->readNumEntry("WindowHeight",320));
}

void KDuDialog::writeSettings(){
	QString entry;

	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();
	config->setGroup("View");

	if (set_user == true) entry = "yes"; else entry = "no";
  	config->writeEntry("User", entry);
	if (set_group == true) entry = "yes"; else entry = "no";
  	config->writeEntry("Group", entry);
	if (set_size == true) entry = "yes"; else entry = "no";
  	config->writeEntry("Size", entry);
	if (set_name == true) entry = "yes"; else entry = "no";
  	config->writeEntry("Name", entry);
	if (set_date == true) entry = "yes"; else entry = "no";
  	config->writeEntry("Date", entry);
	if (set_hidden_dirs == true) entry = "yes"; else entry = "no";
  	config->writeEntry("Hidden_Dirs", entry);
	if (set_hidden_files == true) entry = "yes"; else entry = "no";
  	config->writeEntry("Hidden_Files", entry);

	config->writeEntry("WindowWidth",width());
	config->writeEntry("WindowHeight",height());

	config->sync();
}

void KDuDialog::slot_stopdu(){
	cancel=true;
}

int main(int argc,char *argv[]){
 	KApplication 	*thisapp	= new KApplication(argc,argv,"kdu");
	KDuDialog 	*kdudialog 	= new KDuDialog(thisapp); 

	thisapp->setTopWidget(kdudialog);
	thisapp->setMainWidget(kdudialog);

	kdudialog->show();

	if (argc==2) kdudialog->setPath(argv[1]);

	int ret=thisapp->exec();
	kdudialog->writeSettings();

	delete(kdudialog);
	delete(thisapp);
	
	return ret;
}

