/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Usage V0.9.5                                             *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@wilhelmshaven-online.de                            *
 *                                                                       *
 *************************************************************************/

#ifndef KDU_H
#define KDU_H

#include <qdialog.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpopmenu.h>
#include <qpushbt.h>

#include <kapp.h>
#include <kmenubar.h>
#include <ktablistbox.h>

class KDuDialog:public QDialog{
	Q_OBJECT
public:

	KDuDialog(KApplication *ta=0);
	~KDuDialog();

	void 		resizeEvent(QResizeEvent *);
	void		setColumns();
	void		readSettings();
	void		writeSettings();
	void		setPath(QString p);
	QString		path;

protected:
	unsigned long	readDir(QString name);
	unsigned long	files;
	unsigned long	dirs;
	bool		set_user;
	bool		set_group;
	bool		set_size;
	bool		set_name;
	bool		set_date;
	bool		set_hidden_dirs;
	bool		set_hidden_files;
	bool		cancel;
	KApplication	*thisapp;

private:
	KTabListBox	*output;
	QLabel		*wholesize;
	QLabel		*verzeichnis;
	QPushButton	*chgdir;
	QPushButton	*stopdu;
	QLineEdit	*eingabe;
	QPopupMenu	*file;
	QPopupMenu	*settings;
	QPopupMenu	*help;
	KMenuBar	*menu;

private slots:
	void closeClicked();
	void slotHelp();
	void slotAbout();
	void returnPressed();
	void changeDir();
	void setUser();
	void setGroup();
	void setSize();
	void setName();
	void setDate();
	void setHiddenDirs();
	void setHiddenFiles();
	void makeDu();
	void menuMoved();
	void slot_stopdu();
};

#endif KDU_H

