/***************************************************************************
                          KFlightLog.h  -  description
                             -------------------
    begin                : Sun Jun  6 11:42:22 CEST 1999

    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KFlightLog_H
#define KFlightLog_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>

// application specific includes
#include <kflogview.h>
#include <tablet.h>
#include <mapobject.h>

/**
  * This Class is the base class for KFlightLog. It sets up the main
  * window and reads the config file as well as providing a menubar,
  * toolbar and statusbar. For the main view, an instance of class
  * KFlightLogView is created which creates the view.
  * @author Heiner Lamprecht
  */
class KFLogApp : public KTMainWindow
{
  Q_OBJECT

 public:
  /** construtor */
  KFLogApp();
  /** destructor */
  ~KFLogApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** creates the toolbars. */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the view of the map */
  void initView();
  /** save the app-specific options on slotAppExit or by an Options
    * dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  /** overloaded for Message box on last window exit */
  bool queryExit();
  /** display the coordinates in the statusbar*/
  void showCoords(QPoint coord);
  /** returns a pointer to the current MapObjectList. */
  MapObjectList* getMapObjectList();

 public slots:
  /** show the map */
  void slotShowMap();
  /** show creating */
  void slotShowDig();
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** open a document */
  void slotFileOpen();
  /** print the actual file */
  void slotFilePrint();
  /** exits the application */
  void slotFileQuit();
  /** toggle the toolbar*/
  void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);

 private:
  /**
    * mapObjectList contains all objects to be drawn in the map.
    */
  MapObjectList* mapObjectList;
  /** fileMenu contains all items of the menubar entry "File" */
  QPopupMenu* fileMenu;
  /** viewMenu contains all items of the menubar entry "View" */
  QPopupMenu* viewMenu;
  /** helpMenu contains all items of the menubar entry "Help" */
  QPopupMenu* helpMenu;
  /**
    * view is the main widget which represents your working area. The
    * View class should handle all events of the view widget. It is kept
    * empty so you can create your view according to your application's
    * needs by changing the view class. */
  KFLogView* view;
  /**
    * tabDialog is used for getting configurationdata about the tablet
    * used for digitizing maps. */
  TabletDialog* tabDialog;
  /**
    * flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
  /**
    * used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should
    * add positions as well and implement them in saveOptions() and
    * readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition tool_bar_pos;
  /** the name of the map-file */
  QString mapFile;
};

#endif // KFlightLog_H












