/***************************************************************************
                          map.h  -  class for displaying the map-data
                             -------------------
    begin                : Mon Jun 7 1999
    copyright            : (C) 1999 by Heiner Lamprecht
    email                : heiner@kijumfo.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAP_H
#define MAP_H

#include <qwidget.h>

#include "kflog.h"

/**
  * This class provides basic functions for displaying the flight data.
  * @author Heiner Lamprecht
  * @version 0.0
  **/
class Map : public QWidget
{
  Q_OBJECT

 public:
  /** constructor */
  Map(QWidget* parent=0,KFLogApp* main=0);
  /** destructor */
  ~Map();
  /** changing the scale and redraw the map */
  void setScale(int newScale = 0);
  /** */
  void smallScaleAdd();
  void smallScaleSub();
  void bigScaleAdd();
  void bigScaleSub();
  void redrawMap();

  /** set the type of projection either to "Lambert" or to "Mercator" */
  void setProjection(const char* procType);

  /** returns TRUE, if current projectiontype ist Lambert */
  bool isLambert();

  /** returns TRUE, if current projectiontype ist Mercator */
  bool isMercator();

  void map2Lambert(double x, double y, Location* loc);

  void map2Mercator(double x, double y, Location* loc);

  /** Converts radians to degree. */
  double deg(double rad);

  /** Converts degree to radians. */
  double rad(double deg);

  /** Returns the pointlist */
  void pointList(QPainter* painter);

 public slots:
  void slotScaleAdd();
  void slotScaleSub();

 protected:
  virtual void mousePressEvent(QMouseEvent* event);
  virtual void mouseMoveEvent(QMouseEvent* event);
  virtual void paintEvent(QPaintEvent* event);
  virtual void resizeEvent(QResizeEvent* event);
  void drawMap(QPainter* bP);

 private:
  /**
    * Coordinates of the current mouse-position, needed
    * to show in the status bar
    */
  QPoint _current;
  /**
    * The QPainter in wich the map will be drawn. This painter is
    * about the same size as the map-widget, but only used for internal
    * buffering the map. Whenever the widget ist about to be drawn, this
    * buffer is used to get the content.
    */
  QPixmap _buffer;
  /** Pointer to the current main window */
  KFLogApp *app;
  /**
    * The (internal) scale for the map. This value has nothing in
    * common with the scale of a normal map. It determines a factor
    * with wich the drawn map will be expanded.
    */
  int scale;
  /**
    * The minimum scale. Here the height of 1 point is about 6360.0m.
    */
  static const int minScale = 1000;
  /**
    * The maximum scale. Here the height of 1 point is about 12.72m.
    */
  static const int maxScale = 500000;
  /**
    * The mapCenter is position displayed in the center of the map.
    * It is used in two different ways:
    * 1.: Determine the area shown in the map-widget
    * 2.: Calculating the differenz in latitude between a point in the
    * map and the center.
    */
  long mapCenterLat;
  long mapCenterLon;
  /**
    * Enables drawing of the map.
    * Used to guarantee, that the map will only be drawn, if the widget
    * is already build. Otherwise, the map would be drawn twice when
    * opening a window!
    */
  bool isEnabled;

  /** pi is pi ;-) */
  const static double pi = 3.141592654;

  /**
    * The earth's radius used for calculation.
    * NOTE: We use the earth as a sphere, not as a spheroid! */
  const static double radius = 6370.289509;

  double mercatorScale;

  /** standard parallels for conical projection */
  double v1;

  /** The second standard parallel. It doesn't matter which one is which. */
  double v2;

  /** contains the current projectiontype */
  char* projectionType;
};

#endif
