/***********************************************************************
**
**   areaelement.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include "areaelement.h"

#include <mapcalc.h>

QString AreaElement::getName()
{
  return name;
}

QRegion* AreaElement::drawRegion(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon)
{
  extern double _scale[];
  extern int _scaleBorder[];
  extern double _currentScale;
  double lat, lon, projX, projY, drawX, drawY;

  bool show = true;

  QPointArray pointArray(locLength);

  switch(typeID) {
    case HugeCity:
      show = false;
      if(_currentScale <= _scale[_scaleBorder[17]]) {
        show = true;
        targetPainter->setBrush(QBrush(QColor(245,220,0),Dense2Pattern));
        targetPainter->setPen(QPen(QColor(0,0,0), 1));
      }
      break;
    case BigCity:
      show = false;
      if(_currentScale <= _scale[_scaleBorder[18]]) {
        show = true;
        targetPainter->setBrush(QBrush(QColor(245,220,0),Dense2Pattern));
        targetPainter->setPen(QPen(QColor(0,0,0), 1));
      }
      break;
    case MidCity:
      show = false;
      if(_currentScale <= _scale[_scaleBorder[19]]) {
        show = true;
        targetPainter->setBrush(QBrush(QColor(245,220,0),Dense2Pattern));
        targetPainter->setPen(QPen(QColor(0,0,0), 1));
      }
      break;
    case SmallCity:
      show = false;
      if(_currentScale <= _scale[_scaleBorder[20]]) {
        show = true;
        targetPainter->setBrush(QBrush(QColor(245,220,0),Dense2Pattern));
        targetPainter->setPen(QPen(QColor(0,0,0), 1));
      }
      break;
  }
  if(show) {
    for(unsigned int i = 0; i < locLength; i++) {
      lat = numToRad(latitude[i]);
      lon = numToRad(longitude[i] - mapCenterLon);
      projX = calc_X_Lambert(lat, lon);
      projY = calc_Y_Lambert(lat, lon);
      drawX = (projX * RADIUS / _currentScale) + dX;
      drawY = (projY * RADIUS / _currentScale) + dY;

      pointArray.setPoint(i, drawX, drawY);
    }
    targetPainter->drawPolygon(pointArray);
    return (new QRegion(pointArray));
  } else {
    return (new QRegion(0,0,1,1));
  }
}

AreaElement::AreaElement(QString n, unsigned int t, unsigned int length,
              long* latList, long* lonList)
    : LineElement(n, t, length, latList, lonList)
{

}

AreaElement::~AreaElement()
{

}
