/***********************************************************************
**
**   areaelement.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef AREAELEMENT_H
#define AREAELEMENT_H

#include <lineelement.h>

/**
  * This class is used for mapelements which effect an area. The object
  * can be one of: [Big, Mid, Small]Lake, [Huge, Big, Mid, Small]City,
  * Glacier. Mainly, the class reimplements the drawing-function, so that
  * the object will create a QRegion.
  *
  * @see BaseMapElement#objectType
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */
class AreaElement : public LineElement
{
 public:
  /**
    * Creates a new AreaElement.
    */
  AreaElement(QString n, unsigned int t, unsigned int length,
              long* latList, long* lonList);
  /** */
  ~AreaElement();
  /**
    * Draws the element into the given painter.
    */
  virtual QRegion* drawRegion(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Returns the name of the element.
    */
  virtual QString getName();
};

#endif
