/***********************************************************************
**
**   main.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  1999 by Heiner Lamprecht ( heiner@kijumfo.de )
**   begin        :  Sun Jun  6 1999
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include "kflog.h"
#include <iostream>
#include <unistd.h>
#include <kflogstartlogo.h>

#include <kwmmapp.h>

/**
  * erste Parallele
  */
double _v1;

/**
  * zweite Parallele
  */
double _v2;

double _var1;
double _var2;

/**
  * Anzahl der Mastabsbereiche
  */
const int _scaleNum = 7;

/**
  * Mastabsgrenzen
  */
double _scale[_scaleNum];

/**
  * aktueller Mastab
  */
double _currentScale;

/**
  *
  */
bool _showElements[17];
int _scaleBorder[29];

int main(int argc, char* argv[])
{
  KWMModuleApplication app(argc,argv,"kflog");
  KFLogStartLogo* startLogo=0L;	
	app.connectToKWM();

  app.getConfig()->setGroup("General Options");
  bool bStartLogo= app.getConfig()->readBoolEntry("Logo",true);
  if(argc > 1 ) {
    //start the setupwizard, not implemented yet ...
//    if( QString(argv[1]) == "--setup") bInstall = true;
  }

  if(bStartLogo) {
    startLogo= new KFLogStartLogo;
    startLogo->show();
  }

  if(app.isRestored()) {
    RESTORE(KFLogApp);
    if(bStartLogo){
      startLogo->close();
      delete startLogo;
    }
  } else {
    KFLogApp* kflog = new KFLogApp();
    kflog->show();
    if(bStartLogo) {
      startLogo->raise();
      kflog->slotRedrawMap();
      for(int loop = 1; loop < argc; loop++) {
        QString fileName(argv[loop]);
        if(QFile::exists(fileName)) {
          kflog->slotOpenFlight(fileName);
        }
      }
      startLogo->close();
      delete startLogo;
    } else {
      kflog->slotRedrawMap();
    }
  }
  return app.exec();
}
