/***********************************************************************
**
**   mapcontents.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include "mapcontents.h"

void MapContents::addElement(unsigned int listIndex, SinglePoint* newElement)
{
  switch(listIndex) {
    case VillageList:
      villageList.append(newElement);
      break;
    default:
      warning("SinglePoint: Keine Liste ;-((");
      ; // Do nothing ...
  }
}

void MapContents::addElement(unsigned int listIndex, AreaElement* newElement)
{
  switch(listIndex) {
    case CityList:
      cityList.append(newElement);
      break;
    default:
      warning("AreaElement: Keine Liste ;-((");
      ; // Do nothing ...
  }
}

void MapContents::addElement(unsigned int listIndex, ElevPoint* newElement)
{
  switch(listIndex) {
    case ObstacleList:
      obstacleList.append(newElement);
      break;
    default:
      warning("ElevPoint: Keine Liste ;-((");
      ; // Do nothing ...
  }
}

void MapContents::addElement(GliderSite* newElement)
{
  gliderList.append(newElement);
}

void MapContents::addElement(Airport* newElement)
{
  airportList.append(newElement);
}

void MapContents::addElement(IntAirport* newElement)
{
  intairportList.append(newElement);
}

void MapContents::addElement(RadioPoint* newElement)
{
  navList.append(newElement);
}

void MapContents::addElement(unsigned int listIndex, LineElement* newElement)
{
  switch(listIndex) {
    case HighwayList:
      highwayList.append(newElement);
      break;
    case RoadList:
      roadList.append(newElement);
      break;
    case RailList:
      railList.append(newElement);
      break;
    case HydroList:
      hydroList.append(newElement);
      break;
    default:
      warning("LineElement: Keine Liste ;-((");
      ; // Do nothing ...
  }
}

void MapContents::addElement(Airspace* newElement)
{
  airspaceList.append(newElement);
}

unsigned int MapContents::getListLength(int listIndex)
{
  switch(listIndex) {
    case IntAirportList:
      return intairportList.count();
    case AirportList:
      return airportList.count();
    case GliderList:
      return gliderList.count();
    case OutList:
      return outList.count();
    case NavList:
      return navList.count();
    case AirspaceList:
      return airspaceList.count();
    case ObstacleList:
      return obstacleList.count();
    case ReportList:
      return reportList.count();
    case CityList:
      return cityList.count();
    case VillageList:
      return villageList.count();
    case LandmarkList:
      return landmarkList.count();
    case HighwayList:
      return highwayList.count();
    case HighwayEntryList:
      return highEntryList.count();
    case RoadList:
      return roadList.count();
    case RailList:
      return railList.count();
    case StationList:
      return stationList.count();
    case HydroList:
      return hydroList.count();
    case TopoList:
      return topoList.count();
    default:
      return 0;
  }
}

BaseMapElement* MapContents::getElement(int listIndex, unsigned int index)
{
  switch(listIndex) {
    case IntAirportList:
      return intairportList.at(index);
    case AirportList:
      return airportList.at(index);
    case GliderList:
      return gliderList.at(index);
    case OutList:
      return outList.at(index);
    case NavList:
      return navList.at(index);
    case AirspaceList:
      return airspaceList.at(index);
    case ObstacleList:
      return obstacleList.at(index);
    case ReportList:
      return reportList.at(index);
    case CityList:
      return cityList.at(index);
    case VillageList:
      return villageList.at(index);
    case LandmarkList:
      return landmarkList.at(index);
    case HighwayList:
      return highwayList.at(index);
    case HighwayEntryList:
      return highEntryList.at(index);
    case RoadList:
      return roadList.at(index);
    case RailList:
      return railList.at(index);
    case StationList:
      return stationList.at(index);
    case HydroList:
      return hydroList.at(index);
    case TopoList:
      return topoList.at(index);
    default:
      return 0;
  }
}

SinglePoint* MapContents::getWayPoint(unsigned int index)
{
  switch(waypointList[index]) {
    case AirportList:
      return airportList.at(waypointIndex[index]);
    case GliderList:
      return gliderList.at(waypointIndex[index]);
    case OutList:
      return outList.at(waypointIndex[index]);
    case NavList:
      return navList.at(waypointIndex[index]);
    case ObstacleList:
      return obstacleList.at(waypointIndex[index]);
    case ReportList:
      return reportList.at(waypointIndex[index]);
    case VillageList:
      return villageList.at(waypointIndex[index]);
    case LandmarkList:
      return landmarkList.at(waypointIndex[index]);
    case HighwayEntryList:
      return highEntryList.at(waypointIndex[index]);
    case StationList:
      return stationList.at(waypointIndex[index]);
    default:
      return 0;
  }
}

unsigned int MapContents::getWayPointNumber()
{
  return waypointNumber;
}

MapContents::MapContents()
{
  intairportList.setAutoDelete(true);
  airportList.setAutoDelete(true);
  airspaceList.setAutoDelete(true);
  gliderList.setAutoDelete(true);
  highEntryList.setAutoDelete(true);
  highwayList.setAutoDelete(true);
  hydroList.setAutoDelete(true);
  landmarkList.setAutoDelete(true);
  navList.setAutoDelete(true);
  obstacleList.setAutoDelete(true);
  outList.setAutoDelete(true);
  railList.setAutoDelete(true);
  reportList.setAutoDelete(true);
  roadList.setAutoDelete(true);
  stationList.setAutoDelete(true);
  topoList.setAutoDelete(true);
  villageList.setAutoDelete(true);

  waypointNumber = 0;
  waypointList = new unsigned int[waypointNumber];
  waypointIndex = new unsigned int[waypointNumber];
}

MapContents::~MapContents()
{
  // Hier mssen ALLE Listen gelscht werden!!!
  intairportList.~QList();
  airportList.~QList();
  airspaceList.~QList();
  cityList.~QList();
  gliderList.~QList();
  highEntryList.~QList();
  highwayList.~QList();
  hydroList.~QList();
  landmarkList.~QList();
  navList.~QList();
  obstacleList.~QList();
  outList.~QList();
  railList.~QList();
  reportList.~QList();
  roadList.~QList();
  stationList.~QList();
  topoList.~QList();
  villageList.~QList();
}
