#include <stdio.h>

#include "gps_parse.h"

// KDE stuff
#include <kstatusbar.h>
extern KStatusBar* pStatusBar;

#define GPGGA	"$GPGGA"
#define GPGSV	"$GPGSV"
#define GPGSA	"$GPGSA"
#define GPRMC	"$GPRMC"

#define BUFFERSIZE	4096
static char gps_buffer[BUFFERSIZE];
static char* dest_ptr;

RMCData rmcData;
GSAData gsaData;
GSVData gsvData;
GGAData ggaData;

void gps_init_parser(void)
{
	dest_ptr = &gps_buffer[0];
}

int get_next_token(char* dest, int cnt, char* src)
{
	char* ptr = src;
	int idx = 0;
	int len = strlen(src);
	if(len == 0)	return -1;
	while(idx <= len)
	{
		if(*ptr == ',' || *ptr == '*' || *ptr == '\r' || *ptr == '\0')
		{
			if(idx > cnt)
			{
				dest[0] = 0;
			}
			else
			{
				strncpy(dest, src, idx);
				dest[idx] = 0;
			}
			if(*ptr == '\0')	return -1;
			else			return idx;
		}
		ptr++; idx++;
	}
	return -1;
}

int gps_parse(char* buf, int count)
{
	char* src_ptr = buf;
	int i;
	int cnt = count;
	while(cnt--)
	{
		if(dest_ptr != &gps_buffer[BUFFERSIZE])
			*dest_ptr = *src_ptr++;
		else
		{
			gps_init_parser();
			return -1;
		}
		if(*dest_ptr == '\r')
		{
			char token[64][64];
			int newidx = 1, idx = 0;
			int token_cnt = 0;
			*dest_ptr = '\0';

			//printf("%s\n", (char*)&gps_buffer[0]);

			while(newidx > -1)
			{
				newidx = get_next_token(&token[token_cnt++][0], sizeof(token), &gps_buffer[idx]);
				idx = idx + newidx + 1;
			}

			if(strcmp(GPRMC, &token[0][0]) == 0)
			{
				sscanf(&token[1][0], "%d", &rmcData.utc_time);
				sscanf(&token[2][0], "%c", &rmcData.state);
				sscanf(&token[3][0], "%lf", &rmcData.latitude);
				sscanf(&token[4][0], "%c", &rmcData.latitude_dir);
				sscanf(&token[5][0], "%lf", &rmcData.longitude);
				sscanf(&token[6][0], "%c", &rmcData.longitude_dir);
				sscanf(&token[7][0], "%lf", &rmcData.speed);
				sscanf(&token[8][0], "%lf", &rmcData.heading);
				sscanf(&token[9][0], "%d", &rmcData.date);
				sscanf(&token[10][0], "%lf", &rmcData.magnetic);
				sscanf(&token[11][0], "%c", &rmcData.magnetic_dir);
				rmcData.newdata = 1;
			}
			else if(strcmp(GPGGA, &token[0][0]) == 0)
			{
				printf("%s\n",&gps_buffer[0]);
			}
			else if(strcmp(GPGSA, &token[0][0]) == 0)
			{
				sscanf(&token[1][0], "%c", &gsaData.mode);
				sscanf(&token[2][0], "%d", &gsaData.fixtype);
				for(i = 0; i < 12; i++)
				{
					if(sscanf(&token[i+3][0], "%d", &gsaData.sat[i].prn) < 0)
						gsaData.sat[i].prn = 0;
				}
				sscanf(&token[15][0], "%lf", &gsaData.pos_dilution);
				sscanf(&token[16][0], "%lf", &gsaData.hor_dilution);
				sscanf(&token[17][0], "%lf", &gsaData.ver_dilution);
				gsaData.newdata = 1;
			}
			else if(strcmp(GPGSV, &token[0][0]) == 0)
			{
				int nrofmsg, msgnr, max, j, k;
				sscanf(&token[1][0], "%d", &nrofmsg);
				sscanf(&token[2][0], "%d", &msgnr);
				sscanf(&token[3][0], "%d", &gsvData.num_sats);
				gsvData.num_sats > (msgnr * 4) ? max = 4 : max = gsvData.num_sats%4;
				for(i = 0; i < max; i++)
				{
					j = 4 + 4*i;
					k = i + (msgnr - 1)*4;
					if(sscanf(&token[j][0], "%d", &gsvData.sat[k].prn) < 0)
						gsvData.sat[k].prn = 0;
					if(sscanf(&token[j+1][0], "%d", &gsvData.sat[k].elev) < 0)
						gsvData.sat[k].elev = 0;
					if(sscanf(&token[j+2][0], "%d", &gsvData.sat[k].az) < 0)
						gsvData.sat[k].az = 0;
					if(sscanf(&token[j+3][0], "%d", &gsvData.sat[k].snr) < 0)
						gsvData.sat[k].snr = 0;
				}
				if(msgnr == nrofmsg)
				{
					gsvData.newdata = 1;
				}
			}
			else
			{
				if(gps_buffer[0]  == '$')
				{
					//printf("%s\n",&gps_buffer[0]);
					//fflush(stdout);
				}
			}
			gps_init_parser();
		}
		else if(*dest_ptr == '\n')
		{
			gps_init_parser();
		}
		else
			dest_ptr++;
	}
	return 0;
}
