#include <kbar.h>
#include <kbar.moc>

#include <qlayout.h>

#include <gps_parse.h>

static QRect satListRect(10,10,220,270);
static char* satelite = "Sat.";
static char* signal = "S/N";
static char* azimuth = "Az.";
static char* elevation = "El.";
static int satListcol1 = 50; 
static int satListcol2 = 50; 
static int satListcol3 = 60; 
static int satListcol4 = 60; 
static int satListItems = 12; 

static QRect rmcListRect(10,290,220,130);
static char* dat_loc = "Date/Time and Location";
static int rmcListcol1 = 220; 
static int rmcListItems = 5; 

static QRect activesatListRect(10,430,220,80);
static char* active_satelites = "Active Satellites";
static int activesatListcol1 = 220; 
static int activesatListItems = 2; 


void QListViewSetText(QListViewItem* pListViewItem, int col, char* newtext)
{
	if(strcmp(pListViewItem->text(col), newtext))
		pListViewItem->setText(col, newtext);
}


KBar::KBar(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
	QFont f("Times", 14, QFont::Bold);
	setFont(f);

	int i;
	QListView* satListView = new QListView(this);
	satListView->setFont(f);
	satListView->setGeometry(satListRect);
	satListView->addColumn(satelite, satListcol1);
	satListView->addColumn(signal, satListcol2);
	satListView->addColumn(azimuth, satListcol3);
	satListView->addColumn(elevation, satListcol4);
	for(i = satListItems-1; i > -1; i--)
	{
		plvItem[i] = new QListViewItem(satListView);
	}

	QListView* rmcListView = new QListView(this);
	rmcListView->setFont(f);
	rmcListView->setGeometry(rmcListRect);
	rmcListView->addColumn(dat_loc, rmcListcol1);
	for(i = rmcListItems-1; i > -1; i--)
	{
		prmclvItem[i] = new QListViewItem(rmcListView);
	}

	QListView* activesatListView = new QListView(this);
	activesatListView->setFont(f);
	activesatListView->setGeometry(activesatListRect);
	activesatListView->addColumn(active_satelites, activesatListcol1);
	for(i = activesatListItems-1; i > -1; i--)
	{
		pactivesatlvItem[i] = new QListViewItem(activesatListView);
	}
}

KBar::~KBar()
{
}

extern GSVData gsvData;
extern RMCData rmcData;
extern GSAData gsaData;

void KBar::updateData(void)
{
	int i;
	static char prn[10], snr[10], az[10], elev[10], str[128], tmp[10];
	for(i = 0; i < gsvData.num_sats; i++)
	{
		if(gsvData.sat[i].prn)
		{
			sprintf((char*)&prn[0], "%d", gsvData.sat[i].prn);
			sprintf((char*)&snr[0], "%d", gsvData.sat[i].snr);
			sprintf((char*)&az[0], "%d", gsvData.sat[i].az);
			sprintf((char*)&elev[0], "%d", gsvData.sat[i].elev);
		}
		else
		{
			prn[0] = '\0';
			snr[0] = '\0';
			az[0] = '\0';
			elev[0] = '\0';
		}
		QListViewSetText(plvItem[i], 0, (char*)&prn[0]);
		QListViewSetText(plvItem[i], 1, (char*)&snr[0]);
		QListViewSetText(plvItem[i], 2, (char*)&az[0]);
		QListViewSetText(plvItem[i], 3, (char*)&elev[0]);
	}
	sprintf((char*)&str, "%02d:%02d:%02d", rmcData.utc_time/10000, (rmcData.utc_time - (rmcData.utc_time/10000)*10000)/100, rmcData.utc_time%100);
	QListViewSetText(prmclvItem[0], 0, (char*)&str[0]);
	sprintf((char*)&str, "%02d.%02d.%02d", rmcData.date/10000, (rmcData.date - (rmcData.date/10000)*10000)/100, rmcData.date%100);
	QListViewSetText(prmclvItem[1], 0, (char*)&str[0]);
	sprintf((char*)&str, "%8.4f %c", rmcData.latitude, rmcData.latitude_dir);
	QListViewSetText(prmclvItem[2], 0, (char*)&str[0]);
	sprintf((char*)&str, "%8.4f %c", rmcData.longitude, rmcData.longitude_dir);
	QListViewSetText(prmclvItem[3], 0, (char*)&str[0]);
	sprintf((char*)&str, "%c", rmcData.state);
	QListViewSetText(prmclvItem[4], 0, (char*)&str[0]);
	
	sprintf((char*)&str, "%c %d", gsaData.mode, gsaData.fixtype);
	QListViewSetText(pactivesatlvItem[0], 0, (char*)&str[0]);

	str[0] = '\0';
	for(i = 0; i < 12; i++)
	{
		if(gsaData.sat[i].prn)
		{
			sprintf((char*)&tmp[0], "%d,", gsaData.sat[i].prn);
			strcat(str, tmp);
		}
	}
	str[strlen(str)-1] = '\0';
	QListViewSetText(pactivesatlvItem[1], 0, (char*)&str[0]);
	
/*	sprintf((char*)&str, "%f", gsaData.pos_dilution);
	QListViewSetText(pactivesatlvItem[2], 0, (char*)&str[0]);
	
	sprintf((char*)&str, "%f", gsaData.hor_dilution);
	QListViewSetText(pactivesatlvItem[3], 0, (char*)&str[0]);
	
	sprintf((char*)&str, "%f", gsaData.ver_dilution);
	QListViewSetText(pactivesatlvItem[4], 0, (char*)&str[0]);
*/
}
