/* -*- C++ -*-
 * This file declares the class managing the main window of khost.
 * khost is a GUI to xhost.
 *
 * khost is part of the K Desktop Environment
 * copyright:  (C) Mirko Sucker, 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4
 * $Revision: 1.3 $
 */

#ifndef KHOST_H_INCLUDED
#define KHOST_H_INCLUDED

class StringListSelectAndReorderSet;

#include <ktmainwindow.h>
#include <list>
#include <qtimer.h>
#include <qstrlist.h>
#include <qconfigDB.h>
#include "xhostinterface.h"

class KHost : public KTMainWindow
{
  // ############################################################################
  Q_OBJECT
  // ----------------------------------------------------------------------------
public:
  /** The constructor. */
  KHost(const char* name=0);
  /** The destructor. */
  ~KHost();
  /** The IDs of the toolbar buttons. */
  enum ID {
    No_ID,
    Exit, Control, NewHost, AddHost, RemoveHost, Configure, Help, About
  };
  // ----------------------------------------------------------------------------
protected slots:
  /** Exit the program, querying the user. */
  void exit();
  /** Enable or disable host access control. */
  void enableControl(int);
  /** Add a host. */
  void editHostList();
  /** Add a host to the list of allowed hosts. This is called when a host is
   *  selected and will run xhost to allow access from this host. */
  void add(const QString& host);
  /** Remove a host from the list of allowed hosts. This is called when a host is
   *  selected and will run xhost to forbid access from this host.  */
  void remove(const QString& host);
  /** Configure khost. */
  void configure();
  /** Get help. */
  void help();
  /** Show the about khost window. */
  void about();
  /** Erase statusbar text. */
  void timeout();
  // ----------------------------------------------------------------------------
public slots:
  /** Set a text in the status bar for ten seconds. */
  void setStatus(const QString&);
  /** Save settings from this session. This will copy all settings into the
   *  data file's structure and save it. */
  bool save();
  // ----------------------------------------------------------------------------
protected:
  // methods:
  /** Check and possibly create the data directory. This sets the file name for
   *  the data file. */
  bool checkDataDirectory();
  /** This method is called if the data file does not exist. */
  bool createDataFile();
  /** This method sets all settings of the program to its defaults. */
  bool restoreDefaults();
  /** This will load the data file and transfer all settings to the respective
   *  members of the class.
   *  @see save */
  bool load();
  /** Apply all settings at once. */
  bool apply();
  // members:
  /** The selector box. */
  StringListSelectAndReorderSet *set;
  /** The list of hosts. */
  QStrList hosts;
  /** The allowed hosts in this list. */
  list<int> allowed;
  /** Whether access control is enabled or not. */
  bool control;
  /** Whether to restore the settings on startup or not. */
  bool restore;
  /** Whether to use a background tile in dialogs or not. */
  bool usetile;
  /** The timer for erasing the status bar text. */
  QTimer timer;
  /** The list containing the status messages to display. */
  list<QString> messages;
  /** The file storing the user data. */
  QConfigDB data;
  /** The class managing the calls to xhost. */
  XHostInterface *xhost;
  // ############################################################################
};

#endif // KHOST_H_INCLUDED
