/***************************************************************************
                          kinterruptinfo.cpp  -  description                              
                             -------------------                                         
    begin                : Fri Jun 11 07:42:17 CEST 1999
                                           
    copyright            : (C) 1999 by Enrico Schulz                         
    email                : emmy@online.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kinterruptinfo.h"

Kinterruptinfo::Kinterruptinfo(QWidget*parent,const char* name):QWidget(parent,name){
initializewindow();
}
Kinterruptinfo::~Kinterruptinfo(){
}

void Kinterruptinfo::initializewindow()
{
  this->resize(330, 240);
  tablistbox = new KTabListBox(this, "tablistbox");
  tablistbox->setGeometry(0, 0, 330, 210);
  tablistbox->setNumCols(2);
  tablistbox->setColumn(0, i18n("Interrupt"), 60);
  tablistbox->setColumn(1, i18n("Value"), 170);
  infobutton = new QPushButton(this, "infobutton");
  infobutton->setGeometry(0, 210, 60, 30);
  infobutton->setText(i18n("Info"));
  exitbutton = new QPushButton(this, "exitbutton");
  exitbutton->setGeometry(270, 210, 60, 30);
  exitbutton->setText(i18n("Exit"));
  connect(exitbutton, SIGNAL(clicked()), SLOT(exitclicked()));
  connect(infobutton, SIGNAL(clicked()), SLOT(infoclicked()));
  readfromfile(tablistbox);
}

void Kinterruptinfo::infoclicked()
{
  infdialog = new infodialog(this, "infdialog");
  infdialog->exec();
}

void Kinterruptinfo::readfromfile(KTabListBox *tablistbox)
{
  char splitchar = ':';
  QString str;
  char buf[512];
  tablistbox->setSeparator(splitchar);
  QFile *file = new QFile("/proc/interrupts");

  if (!file->open(IO_ReadOnly))
  {
    delete file;
  }
  while (file->readLine(buf, sizeof(buf)-1)>0)
  {
    if (strlen(buf))
    {
      char *p=buf;
      if (splitchar!=0)
      while (*p)
      {
        if (*p==splitchar)
        {
          *p++ = ' ';
          while (*p == ' ') ++p;
          *(--p) = splitchar;
          ++p;
        }
        else ++p;
      }
      tablistbox->insertItem(buf);
    }
  }
  file->close();
  delete file;
}
void Kinterruptinfo::exitclicked()
{
  close();
}

