/*
 * $Id: graph.cc,v 1.1.1.1 1999/11/24 18:22:40 lord Exp $
 *
 * KLAVG Simple applet showing load average graph on KDE toolbar.
 *
 * Vadim Zaliva <lord@crocodile.org>
 * http://www.crocodile.org/
 * 
 * Copyright (C) 1999 Vadim Zaliva
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <qpainter.h>
#include "graph.h"

//#include <stdio.h>
#include <math.h>

Graph::Graph(QWidget *parent):QWidget(parent, "Graph")
{
    for(int i=0;i<LAST_POINTS;i++)
        points[i]=0.0;
    current=0;

    // default colour scheme
    bgcolour   = black ;
    fgcolour   = yellow;
    gridcolour = red   ;
}

void Graph::addPoint(float p)
{
    points[current++]=p;
    if(current==LAST_POINTS)
        current=0;
    paintAll();
}

void Graph::paintEvent(QPaintEvent *)
{
    paintAll();
}

void Graph::resizeEvent(QResizeEvent *)
{
    paintAll();
}

float Graph::maxPoint()
{
    float maxp=points[0];
    for(int i=1;i<LAST_POINTS;i++)
        if(points[i]>maxp)
            maxp=points[i];
    return maxp;
}

void Graph::paintAll()
{
    const int SCALE=1000;
    int my=int(ceil(maxPoint())*SCALE);

    if(my==0)
        return;

    QPainter p(this);
    p.setViewXForm(TRUE  );
    p.setWorldXForm(FALSE);
    //p.setViewport(0,0,width(),height());
    p.setWindow(0,0,LAST_POINTS-1,my);
    p.eraseRect(0,0,LAST_POINTS-1,my);
    //p.setPen(fgcolour);
    p.setBrush(fgcolour);

    int n=2;
    QCOORD data[(LAST_POINTS+2)*2];
    
    for(int i=current;i<LAST_POINTS;i++)
    {
        data[n++] = n/2-1;
        data[n++] = (short)(my-(points[i]*SCALE));
    }
    for(int i=0;i<current;i++)
    {
        data[n++] = n/2-1;
        data[n++] = (short)(my-(points[i]*SCALE));
    }
    data[0]=data[2];        data[1]=my;
    data[n]=data[n-2];n++;  data[n++]=my;

    QPointArray a;
    a.setPoints(LAST_POINTS+2,data);
    p.drawPolygon(a,FALSE);

    // Draw grid
    if(my>SCALE)
    {
        p.setPen(gridcolour);
        for(int i=0;i<=(my/SCALE);i++)
        {
            p.drawLine(0,my-i*SCALE,LAST_POINTS,my-i*SCALE);
        }
    }
    p.flush();
}

Graph::~Graph()
{
}

void Graph::mousePressEvent(QMouseEvent *e)
{
    if(e->button() == RightButton) 
    {
        emit rightMouseButtonPressed();
    } 
    else if(e->button() == LeftButton) 
    {
        emit leftMouseButtonPressed();
    } 
}

/*
 * Chaging colour scheme cause redraw 
 */
void Graph::setColours(QColor &pbgcolour,
                       QColor &pfgcolour,
                       QColor &pgridcolour)
{
    bgcolour   = pbgcolour   ;
    fgcolour   = pfgcolour   ;
    gridcolour = pgridcolour ;
    
    setBackgroundColor(bgcolour);
    paintAll();
}


#include "graph.moc"
