/*
 * $Id: graph.h,v 1.1.1.1 1999/11/24 18:22:40 lord Exp $
 *
 * KLAVG Simple applet showing load average graph on KDE toolbar.
 *
 * Vadim Zaliva <lord@crocodile.org>
 * http://www.crocodile.org/
 * 
 * Copyright (C) 1999 Vadim Zaliva
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef GRAPH_H
#define GRAPH_H

#include <qwidget.h>

#define LAST_POINTS 32

class Graph : public QWidget
{
    Q_OBJECT

signals:
     void rightMouseButtonPressed(void);
     void leftMouseButtonPressed(void);
        
 public:
    Graph(QWidget *parent);
    virtual ~Graph();

    void addPoint(float p);

    void setColours(QColor &bgcolour,
                    QColor &fgcolour,
                    QColor &gridcolour
    );
    
 protected:

    virtual void mousePressEvent(QMouseEvent  *);
    virtual void paintEvent     (QPaintEvent  *);
    virtual void resizeEvent    (QResizeEvent *);
    
 private:

    float maxPoint();
    void  paintAll();

    int   current;
    float points[1280];

    QColor bgcolour  ;
    QColor fgcolour  ;
    QColor gridcolour;

};

#endif // GRAPH_H
