/*
 * $Id: klavg.h,v 1.3 1999/12/19 07:52:17 lord Exp $
 *
 * KLAVG Simple applet showing load average graph on KDE toolbar.
 *
 * Vadim Zaliva <lord@crocodile.org>
 * http://www.crocodile.org/
 * 
 * Copyright (C) 1999 Vadim Zaliva
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef KLAVG_H
#define KLAVG_H

#include <kapplet.h>
#include <qpopupmenu.h>
#include <kprocess.h>

#include "graph.h"
#include "prefsdlg.h"
#include "dyntip.h"

class KLavg : public KApplet
{
    Q_OBJECT

    QTimer timer;
        
public:
    KLavg();
    virtual ~KLavg();

    void setupGeometry( Orientation orientation, int width, int height );
     
public slots:
     void tick  ();
     void click ();
     void config();
     void about ();
     void quit  ();
     void popupMenu();

 protected:
     virtual void resizeEvent(QResizeEvent *);

 private:
     void loadCfg();
     void saveCfg();
     void newCfg(KlavgPrefs &cfg);
     
     KProcess   process;
     float getLAVG();
     Graph      *graph;
     QPopupMenu *popup;
     DynamicTip *tip;

     KlavgPrefs cfg;
};

#endif // KLAVG_H
