//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees
// E-Mail  : norbert@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#include "tab.h"

TabWindow::TabWindow( const int value, QWidget *parent, const char *name )
	: QDialog( parent, name , true ) {

	
	setCaption( klocale->translate( "Options" ) );


	QFrame *frame = new QFrame( this );
	frame->setFrameStyle( QFrame::Box | QFrame::Sunken ); 
	frame->setFixedSize( 210, 50 );
	frame->move( 10, 10 );

	QLabel *label = new QLabel( this );
	label->setText( klocale->translate( "set new tab width :" ) );
	label->setFixedSize( 140, 30 );
	label->move( 20, 20 );

	spin = new KNumericSpinBox( this );
	spin->setFixedSize( 50, 30 );
	spin->move( 160, 20 );
	spin->setRange( 1, 8 );
	spin->setValue( value );

	QPushButton *ok = new QPushButton( this );
	ok->setText( klocale->translate( "Ok" ) );
	ok->setFixedSize( 100, 30 );
	ok->move( 10, 70 );
	connect( ok, SIGNAL( released() ), this, SLOT( accept() ) ); 

	QPushButton *cancel = new QPushButton( this );
	cancel->setText( klocale->translate( "Cancel" ) );
	cancel->setFixedSize( 100, 30 );
	cancel->move( 120, 70 );
	connect( cancel, SIGNAL( released() ), this, SLOT( CancelExit() ) ); 

	resize( 230, 110 );
	setFixedSize( size() );
}

int TabWindow::getTab() {

	return spin->getValue();
}

void TabWindow::CancelExit() {
	
	spin->setRange( -1, 0 );
	spin->setValue( -1 );
	reject();	
}
