/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: Item.cpp,v 1.49 1999/01/14 17:33:05 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qapplication.h>
#include <qpainter.h>

#include "DynamicTip.h"

DynamicTip::DynamicTip( QWidget * parent ) : QToolTip( parent )
{
}

DynamicTip::~DynamicTip()
{
}

void DynamicTip::maybeTip( const QPoint &pos )
{
  if ( !parentWidget()->inherits( "DockWidget" ) )
    return;
  
  QRect r(((DockWidget *)parentWidget())->tip(pos));
  if ( !r.isValid() )
    return;
  
  tip( r, tipStr );
}                                 

void DynamicTip::setTip( QString &s )
{
  tipStr = s;	
}
#include "DynamicTip.moc.cpp"
