/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: Lm80Voltage.h,v 1.1 1999/01/21 20:51:48 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LM80VOLTAGE_H
#define LM80VOLTAGE_H

#include "Sensors.h"
#include "StdVoltage.h"

class Lm80Voltage : public Sensor
{
private:
  QString sensorName;
  double convFactor;
  StdVoltage *in0;
  
public:
  Lm80Voltage(
    int sysc1, 
    int sysc2, 
    int sysc3,
    int sysc4,
    int in0Sysc4,
    double in0DefaultConv,
    double grMin,
    double grMax,
    char *defaultName,
    double defaultConvFactor );
  
  ~Lm80Voltage();
  
  bool save();	
  void name( QString &name );
  bool setName( QString &name );
  double scale();	
  bool setScale( double scaleFactor );	
  bool increaseScale();
  bool decreaseScale();	
  bool increaseGraphRange();
  bool decreaseGraphRange();
  bool write( SensorValue &val );	
  bool read( SensorValue &val );
  bool displayDecimals();
  bool displayUnits();
  void units( QString &unitStr );	
  bool isAlarm();
};

#endif 
