/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: StdFan.h,v 1.2 1999/01/12 20:38:16 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef STDFAN_H
#define STDFAN_H

#include "Sensors.h"

class StdFan : public Sensor
{
private:
  QString sensorName;
  
public:
  StdFan(
    int sysc1, 
    int sysc2, 
    int sysc3,
    int sysc4,
    double grMin,
    double grMax, 
    char *defaultName	);
  
  ~StdFan();
  
  bool save();	
  void name( QString &name );
  bool setName( QString &name );
  double scale();	
  bool setScale( double scaleFactor );
  bool increaseScale();
  bool decreaseScale();	
  bool increaseGraphRange();
  bool decreaseGraphRange();
  bool read( SensorValue &val );
  bool write( SensorValue &val );	
  bool displayDecimals();
  bool displayUnits();
  bool highAlarmSettable();
  void units( QString &unitStr );		
  bool isAlarm();
};

#endif
