/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: VertGraph.h,v 1.24 1999/01/24 16:21:46 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef VERTGRAPH_H
#define VERTGRAPH_H

#include <qlabel.h>
#include <qframe.h>
#include <qevent.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qpalette.h>


class VertGraph : public QFrame
{
  Q_OBJECT
  
private:
  virtual void paintEvent( QPaintEvent * e);
  void mousePressEvent( QMouseEvent *e );
  void mouseMoveEvent( QMouseEvent *e );
  void mouseReleaseEvent( QMouseEvent *e );
  void drawHystGraph();
  void drawNormalGraph();
  
  enum SelectItem	{ NONE = 0, LOWER = 1, UPPER =2 };
  
  double      max;
  double      min;
  double      data;
  double      last_data;
  double      low_alarm;
  double      high_alarm;	
  double      scale;
  double      low_alarm_min;
  double      high_alarm_min;	
  QColor      bg;
  QColor      text;
  QColor      dark_red;
  QColor      dark_green;
  QColor      dark_yellow;	
  QColorGroup *redCg;
  QColorGroup *greenCg;
  bool        configuring;
  bool        lowAlarmIsSettable;
  bool        highAlarmIsSettable;
  bool        isScalable;
  int         selItem;
  bool        alarmSounding;
  bool        isHystGraph;
  
  int dataToY( 
    int graph_height, 
    double max, 
    double min, 
    double value );
  
  double	yToData( 
    int graph_height, 
    double	max, int y );
  
  int	whatClicked( int y );
  
  void checkMinMax( double &min, double &max);
  
  void forceInRange( double &val );
  
public:
  
  VertGraph( 
    QWidget* parent = NULL,
    const char* name = NULL,
    double min_val = 0,
    double max_val = 100,
    bool lowAlarmSettable = true,
    bool highAlarmSettable = true,
    bool scalable = false,
    bool hystGraph = false	);
  
  ~VertGraph();
  
  void plot( 
    double GrMin, 
    double GrMax, 
    double lwAlarm, 
    double hiAlarm, 
    double value,
    bool   sensorAlarm );
  
  void getConfig( 
    double &minVal, 	
    double &maxVal,
    double &minAlarmVal,
    double &maxAlarmVal );
  
signals:
  void newLimits( double, double );
  void mouseReleased( void );
  void configurationRequest();
  
public slots:
  void configureYourself( bool );
  
protected slots:
  
  
};



#endif // Graph_included
