#include <ktopwidget.h>
#include <kapp.h>
#include <qwidget.h>
#include <kkeyconf.h>
#include <kmsgbox.h>
#include "klocate.h"

klocate :: klocate(QWidget *parent, const char *name)
	: KTopLevelWidget(name)
{
	label=new QLabel(this);
	label->setText("File to locate : ");
	label->setAlignment(AlignCenter);
	label->setMargin(5);
	label->resize(label->sizeHint());
	line=new KLined(this,"file");
	line->setFocus();
	connect(line,SIGNAL(returnPressed()),this,SLOT(doit()));
	box=new QListBox(this);
}


klocate :: ~klocate()
{
//	KMsgBox :: message(this,"end","This is the end");

}

void klocate::doit()
{
FILE *pi;
char cmd[1024],bline[1024];
int found;

	found=0;
	box->clear();
	sprintf(cmd,"locate %s",line->text());
	pi=popen(cmd,"rt");
	if (pi) {
		while(1) {
			fgets(bline,sizeof(bline),pi);
			if (feof(pi)) break;
			box->insertItem(bline);
			found++;
			}
		pclose(pi);
		}
	if (!found) box->insertItem("*** nothing found ***");
}

void klocate::resizeEvent(QResizeEvent *)
{
	line->setGeometry(label->width(),0,
		width()-label->width(),line->height());
	box->move(0,line->height());
	box->setGeometry(0,line->height(),width(),height()-line->height());
}

int main(int argc, char* argv[])
{

	KApplication *app=new KApplication(argc,argv);
	klocate *locate=new klocate;

	app->setMainWidget(locate);
	locate->show();

	app->exec();

	return(0);
}

