#include <stdio.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include "dlgadditem.h"

AddItemDlg::AddItemDlg(QWidget* parent=0, const char* name=0):
     QDialog (parent, name, TRUE)
{
KIconLoader IconLoader;

   setFixedSize(400,150);

   QLabel *NameLab = new QLabel(i18n("Name"), this);
   NameLab->setGeometry(20,10,80,20);
   NameEdit = new QLineEdit(this);
   NameEdit->setGeometry(100,10,260,22);

   QLabel *PfadLab = new QLabel(i18n("Dir"), this);
   PfadLab->setGeometry(20,50,80,20);
   PfadEdit = new QLineEdit(this);
   PfadEdit->setGeometry(100,50,260,22);
   QPushButton * PfadSuchenBtn = new QPushButton(this);
   PfadSuchenBtn->setGeometry(365,47,30,30);
   PfadSuchenBtn->setPixmap(IconLoader.loadIcon("viewmag+.xpm"));
   connect(PfadSuchenBtn,SIGNAL(clicked()), this, SLOT(PfadSuchenBtnClick()));

   QPushButton *OkBtn = new QPushButton("OK", this, "OkBtn");
   OkBtn->setGeometry(30,height()-40,80,30);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()) );
   QPushButton *CancelBtn = new QPushButton("Cancel", this, "CancelBtn");
   CancelBtn->setGeometry(width()-110,height()-40,80,30);
   connect(CancelBtn, SIGNAL(clicked()), SLOT(reject()) );
}

void AddItemDlg::PfadSuchenBtnClick() {
   debug("PfadSuchenBtnClick");
   QString f = KDirDialog::getDirectory("./", this, "SetiDirSel");
   if (!f.isEmpty()) {
      PfadEdit->setText(f);
   }
}