#include <stdio.h>
#include <kapp.h>
#include "dlgskymap.h"

SkymapDlg* Skymap;

SkymapDlg::SkymapDlg(TChart* TC, QWidget* parent=0, const char* name=0):
     QDialog (NULL, name, FALSE)
{
QString Strg;

   setCaption(i18n("look@seti Skymap"));
   Chart=TC;

   Map=new QPixmap();
   Paint=new QPainter();
   //Scroller=new QScrollView(this,"Scroller");
   //Scroller->setGeometry(0,0,965,482);
   //Scroller->addChild(*Paint);

   Strg=KApplication::kde_datadir()+"/klseti/maps/skymap.xpm";
debug("datadir=%s",Strg.data());
   if (QFile::exists(Strg)) {
      Map->load(Strg);
      IWidth=Map->width();
      IHeight=Map->height();
      setFixedSize(IWidth,IHeight);


   } else
      debug("Datei nicht gefunden "+Strg);
}

void SkymapDlg::closeEvent( QCloseEvent * qev) {
   QDialog::closeEvent(qev);
   Skymap=NULL;
}

void SkymapDlg::paintEvent( QPaintEvent *) {
QListViewItem* QL;
SetiPtr SP;
QString Strg;
QRgb Farbe=qRgb(0,0,0);
int DisplayFlag;

   Paint->begin(this);
   Paint->drawPixmap(0,0, *Map);

   // Eintragen der Positionen
   QL = Chart->SetiList->firstChild();
   while (QL) {
      int PX,PY,PX1,PY1;
      Strg = QL->text(NUMBER);
      SP = (SetiPtr)(Strg.toULong());
      DisplayFlag=TRUE;
      switch (SP->Status) {
         case S_READY     : Farbe=qRgb(0,200,0);break;
         case S_WORKING   : Farbe=qRgb(255,255,0);break;
         case S_WAITING   : Farbe=qRgb(200,0,0);break;
         default : DisplayFlag=FALSE;  //nicht anzeigen
      }


      if (DisplayFlag) {
         // Startpunkt
         PX = int(SP->Start_Ra*IWidth/24.0);
         // Shiften
         PX=PX+IWidth/2;
         if (PX>IWidth) PX-=IWidth;
         PX=IWidth-PX;  //drehen

         PY = int(SP->Start_Dec*IHeight/180.0);
         // Shiften
         PY=PY+IHeight/2;
         if (PY>IHeight) PY-=IHeight;
         PY=IHeight-PY; //drehen

         // Endpunkt
         PX1 = int(SP->End_Ra*IWidth/24.0);
         // Shiften
         PX1=PX1+IWidth/2;
         if (PX1>IWidth) PX1-=IWidth;
         PX1=IWidth-PX1;  //drehen

         PY1 = int(SP->End_Dec*IHeight/180.0);
         // Shiften
         PY1=PY1+IHeight/2;
         if (PY1>IHeight) PY1-=IHeight;
         PY1=IHeight-PY1; //drehen

         Paint->setPen(NoPen);
         Paint->setBrush(Farbe);
         Paint->drawRect(PX-2,PY-2,5,5);
         Paint->setPen(SolidLine);
         Paint->setPen(Farbe);
         Paint->drawLine(PX,PY,PX1,PY1);
         Paint->drawText(PX+5,PY+5,SP->Name);
         debug("Name=%s PX=%d PY=%d",SP->Name,PX,PY);
      }
      QL = QL->nextSibling();
   }
   Paint->setPen(SolidLine);
   Paint->setPen(qRgb(0,200,0));  Paint->drawText(10,10,i18n("Finished WU"));
   Paint->setPen(qRgb(255,255,0));Paint->drawText(10,22,i18n("Working WU"));
   Paint->setPen(qRgb(200,0,0));  Paint->drawText(10,34,i18n("Waiting WU"));

   // Legende
   
   Paint->end();
}
