/***************************************************************************
                          kluach.cpp  -  description
                             -------------------
    begin                : Wed Nov 10 23:11:32 EST 1999
    copyright            : (C) 1999 by Jonathan Singer
    email                : jsinger@leeta.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software and can be used or redistributed        *
 *   subject to the included license.                                      *
 *                                                                         *
 ***************************************************************************/

#include "kluach.h"
#include "kmenubar.h"
#include "qpushbutton.h"
#include "qpainter.h"
#include "qrect.h"
#include "qkeycode.h"
#include "qfont.h"
#include <qmessagebox.h>
#include "setyear.h"
#include "time.h"
#include "string.h"
#include "stdio.h"
#include "kconfig.h"
#include "klocale.h"
#include "khelpmenu.h"
#include "kconfig.h"



Kluach::Kluach(QWidget *parent, const char *name) : QWidget(parent, name)
{
//    resize( 622, 441 );

    menu = new KMenuBar( this, "menu");
    menu->setSeparator( QMenuBar::InWindowsStyle );
    filemenu = new KPopupMenu;
    PRINT = filemenu->insertItem( i18n("Print") );
    filemenu->setItemEnabled( PRINT, FALSE );
    filemenu->insertSeparator();
    QUIT = filemenu->insertItem( i18n("&Quit"), qApp, SLOT(quit()), CTRL+Key_Q );
 		menu->insertItem( i18n("&File"), filemenu, CTRL+Key_F );

    optionsmenu = new KPopupMenu;
    optionsmenu->insertItem( i18n("Gregorian"), 0 );
    optionsmenu->insertItem( i18n("Julian"), 1 );
  	optionsmenu->insertSeparator();
  	optionsmenu->insertItem( i18n("Diaspora"), 3 );
  	optionsmenu->insertItem( i18n("Israel"), 4 );
  	optionsmenu->insertSeparator();
  	optionsmenu->insertItem( i18n("Parsha"), 6 );
  	optionsmenu->insertItem( i18n("Omer"), 7 );
  	optionsmenu->insertItem( i18n("Chol HaMoed"), 8 );
  	menu->insertItem( i18n("&Options"), optionsmenu, CTRL+Key_O );
  	optionsmenu->setCheckable(TRUE);
    connect( optionsmenu, SIGNAL(activated( int )), SLOT(optionsmenuHandler( int )) );
    	  	
    monthmenu = new KPopupMenu;
    	monthmenu->insertItem(  i18n("January"), 0  );
    	monthmenu->insertItem(  i18n("February"), 1  );
    	monthmenu->insertItem(  i18n("March"), 2 );
    	monthmenu->insertItem(  i18n("April"), 3 );
    	monthmenu->insertItem(  i18n("May"), 4 );
    	monthmenu->insertItem(  i18n("June"), 5 );
    	monthmenu->insertItem(  i18n("July"), 6 );
    	monthmenu->insertItem(  i18n("August"), 7 );
    	monthmenu->insertItem(  i18n("September"), 8 );
    	monthmenu->insertItem(  i18n("October"), 9 );
    	monthmenu->insertItem(  i18n("November"), 10 );
    	monthmenu->insertItem(  i18n("December"), 11 );
    	menu->insertItem(  i18n("&Month"), monthmenu, CTRL+Key_M );
    	connect( monthmenu, SIGNAL(activated( int )), SLOT(monthmenuHandler( int )) );
    				
    yearmenu = new KPopupMenu;
    	yearmenu->insertItem( i18n("Next Year"), 0 );
    	yearmenu->setAccel( CTRL+Key_BracketRight, 0 );
    	yearmenu->insertItem( i18n("Previous Year"), 1 );
    	yearmenu->setAccel( CTRL+Key_BracketLeft, 1 );
    	yearmenu->insertItem( i18n("Select Year..."), 2 );
    	menu->insertItem( i18n("&Year"), yearmenu, CTRL+Key_Y );
    	connect( yearmenu, SIGNAL(activated( int )), SLOT(yearmenuHandler( int )) );

    	khelp = new KHelpMenu(this, "Kluach written by Jonathan Singer\n\nCopyright 1999-2000\n\nQuestions, suggestions or flames?\nContact: jsinger@leeta.net\nhttp://www.leeta.net/kluach/\n", 0);
      menu->insertItem( i18n("&Help"), khelp->menu() );

    		
    previous = new QPushButton( i18n("Previous month"), this, "previous" );
    previous->setGeometry( 30, 40, 120, 30 );
    connect( previous, SIGNAL(clicked()), SLOT(decreaseMonth()) );

    next = new QPushButton( i18n("Next month"), this, "next" );
    next->setGeometry( this->width()-30-120, 40, 120, 30 );
    connect( next, SIGNAL(clicked()), SLOT(advanceMonth()) );

    KConfig *config = kapp->config();
  	config->setGroup("Settings");	
    JulianP = config->readBoolEntry("Julian",false);
    IsraelP = config->readBoolEntry("Israel",false);
    Parsha = config->readBoolEntry("Parsha",true);
    Omer = config->readBoolEntry("Omer",true);
    CholHaMoed = config->readBoolEntry("Chol_HaMoed",true);

   	setJulianP(JulianP);
   	setIsraelP(IsraelP);

   	
//   	Parsha=TRUE;
// 		Omer=TRUE;
// 	  CholHaMoed=TRUE;
 	  optionsmenu->setItemChecked( 6, Parsha);
 	  if (!Parsha) HolidayFlags ^= (1 << 0 );
 	  optionsmenu->setItemChecked( 7, Omer);
 	  if (!Omer) HolidayFlags ^= (1 << 1 );
 	  optionsmenu->setItemChecked( 8, CholHaMoed);
 	  if (!CholHaMoed) HolidayFlags ^= (1 << 2 );
 	
 	  time_t now;
 	  now = time(NULL);
 	  tm *date_struct = localtime(&now);
 	  monthmenuHandler( date_struct->tm_mon);
 	  year = date_struct->tm_year + 1900;
}

Kluach::~Kluach()
{

}

void Kluach::WriteSettings()
{
    KConfig *config = kapp->config();
    config->setGroup("Settings");
    config->writeEntry("Julian",JulianP);
    config->writeEntry("Israel",IsraelP);
    config->writeEntry("Omer",Omer);
    config->writeEntry("Parsha",Parsha);
    config->writeEntry("Chol_HaMoed",CholHaMoed);
}

void Kluach::setJulianP( bool status )
{
		JulianP=status;
		optionsmenu->setItemChecked( 0, !JulianP);
		optionsmenu->setItemChecked( 1, JulianP);
		update();
		WriteSettings();
}

void Kluach::setIsraelP( bool status )
{
		IsraelP=status;
		optionsmenu->setItemChecked( 3, !IsraelP);
		optionsmenu->setItemChecked( 4, IsraelP);
		update();
		WriteSettings();
}

void Kluach::advanceYear()
{
 		if (year<2999) {year+=1; update(); }
}

void Kluach::decreaseYear( )
{
 		if (year>1) {year-=1; update(); }
}

void Kluach::advanceMonth()
{
 		if (month==12){
 		monthmenuHandler( 0 );
 		advanceYear();
 		}
 		else {
 		monthmenuHandler( month );
 		}
}

void Kluach::decreaseMonth( )
{
 		if (month==1) {
 		monthmenuHandler( 11 );
 		decreaseYear();
 		}
 		else {
 		monthmenuHandler( month - 2 );
 		}
}

void Kluach::optionsmenuHandler( int id )
 {
switch (id) {
							case 0:   // Gregorian
								setJulianP(FALSE);
								break;
							case 1:   // Julian
								setJulianP(TRUE);
								break;
							case 2: case 5:
								break;
							case 3:  //Diaspora
								setIsraelP(FALSE);
								break;
							case 4:  //Israel
								setIsraelP(TRUE);
								break;
							case 6:  //Show Parsha
								Parsha=!Parsha;
								optionsmenu->setItemChecked( 6, Parsha);
								HolidayFlags ^= (1 << 0 ); 	
 								update();
 								WriteSettings();
								break;
							case 7: //Show omer
								Omer=!Omer;
								optionsmenu->setItemChecked( 7, Omer);
								HolidayFlags ^= (1 << 1 ); 	
 								update();
								WriteSettings();
								break;
							case 8: //Show Chol HaMoed
                CholHaMoed=!CholHaMoed;
								optionsmenu->setItemChecked( 8, CholHaMoed);
								HolidayFlags ^= (1 << 2 );
								update();
								WriteSettings();
								break;
    }

}


void Kluach::monthmenuHandler( int id )
 {
 monthmenu->setItemChecked( month-1, FALSE);
 month = id+1;
 monthmenu->setItemChecked(month-1, TRUE);
 update();
 }


void Kluach::yearmenuHandler( int id )
 {
 		switch (id) {
							case 0:   // Next year
								advanceYear();
								break;
							case 1: 	//Previous year
								decreaseYear();
								break;
							case 2:   //Set year
								openYearDialog();
								break;
								}
	}

	
void Kluach::resetYear( int newyear )
{
	year=newyear;
	update();
}

void Kluach::openYearDialog()
{
	setyear=new setYear( 0, "setyear", year );
	connect(setyear, SIGNAL(valueChanged(int)), SLOT(resetYear(int)) );
}

	
void  Kluach::paintEvent( QPaintEvent * )
{
// resize menu - don't know why it's not automatic
/*int menuHeight = menu->height();
int menuWidth = this->width();
menu->resize(menuWidth, menuHeight); */


QPainter p;
QPen pen( black, 1);
int calendarWidth=this->width()-6;
int dateBoxWidth=calendarWidth/7;

/*static char *DayNames[7]; //= { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" };
DayNames[0]="Sun"; DayNames[1]="Mon";
DayNames[2]="Tue"; DayNames[3]="Wed";
DayNames[4]="Thu"; DayNames[5]="Fri"; DayNames[6]="Sat";*/
QString DayNames(i18n("SunMonTueWedThuFriSatSun"));

// draw day names
p.begin( this );
p.setPen( pen );
p.setFont( QFont( "times", 12, QFont::Bold ) );
p.translate( 3, 91 );
for (int i=0; i<=6; i++ )
{
p.drawText( i*dateBoxWidth, 0, dateBoxWidth+1, 15, AlignCenter, DayNames.mid(i*3,3),  -1 );
}

p.end();

DrawGrid();
next->setGeometry( this->width()-30-120, 40, 120, 30 );

// draw calendar
FillInCalendar( year, month );

}

void Kluach::FillInCalendar( int secular_year, int secular_month )
{

    struct DateResult result;
    int row, column;
    int days_in_secular_month, days_in_hebrew_month;
    int secular_day, hebrew_day, hebrew_month, hebrew_year;
    int hebrew_kvia, hebrew_day_number;
    Boolean hebrew_leap_year_p;
    char *hebrew_month_name, **holidays;
    int initial_hebrew_day = 0, final_hebrew_day = 0;
    int initial_hebrew_year = 0, final_hebrew_year = 0;
    char *initial_hebrew_month = "\0", *final_hebrew_month = "\0", buffer[100];

 	SecularToHebrewConversion(secular_year, secular_month, 1, JulianP, &result);
    days_in_secular_month = result.secular_month_length;
    column = result.day_of_week;
   // Print the header, with the month name
    FillInMonth(result.secular_month_name );
	
	// Fill in each day of the calendar	
		for (row = 0, secular_day = 1; secular_day <= days_in_secular_month;) {
		// at this point, we're either on the first day of the secular month, or
		// the first day of the Hebrew month.
 		if (secular_day > 1)
 			SecularToHebrewConversion(secular_year, secular_month, secular_day, JulianP, &result);
    	days_in_hebrew_month = result.hebrew_month_length;
     	hebrew_day = result.day;
    	hebrew_month = result.month;
    	hebrew_year = result.year;

    	hebrew_leap_year_p = result.hebrew_leap_year_p;
    	hebrew_kvia = result.kvia;
    	hebrew_month_name = result.hebrew_month_name;
    	hebrew_day_number = result.hebrew_day_number;
    	if (secular_day == 1) {
    		// remember info about the first day of the secular month
    		initial_hebrew_day = hebrew_day;
    		initial_hebrew_year = hebrew_year;
    		initial_hebrew_month = hebrew_month_name;
    	}
    	while ((secular_day <= days_in_secular_month) &&
    		   (hebrew_day <= days_in_hebrew_month)) {
    	    holidays = FindHoliday(hebrew_month, hebrew_day, column+1,
    						       hebrew_kvia, hebrew_leap_year_p, IsraelP,
    						       hebrew_day_number, hebrew_year);
   			DoTheOutput(column, row, secular_day,
		                   hebrew_year, hebrew_month_name, hebrew_day, holidays);
		    if (secular_day == days_in_secular_month) {
		    	// remember information about the last day of the month
    			final_hebrew_day = hebrew_day;
    			final_hebrew_year = hebrew_year;
    			final_hebrew_month = hebrew_month_name;
    		}
			secular_day++; hebrew_day++; hebrew_day_number++;
			// increment the column.  Go to the next row if it's Saturday.
			if (++column == 7)
				{ column = 0; row++; }
       	    }
        }

  QPainter p;
	QPen pen( black, 1);
  p.begin( this );
	p.setPen( pen );
	p.setFont( QFont( "times", 12, QFont::Bold ) );
	p.translate( (this->width()/2), 30 );
    if (initial_hebrew_month == final_hebrew_month)  // only in February
    	{
    	sprintf(buffer, "%d -  %d %s  %d", initial_hebrew_day,
    			            final_hebrew_day, final_hebrew_month, final_hebrew_year);
    	p.eraseRect( ((this->width()-300)/-2), 30, (this->width()-300), 30);
			p.end();
			}
    else if (initial_hebrew_year == final_hebrew_year)
    	// different month, same year.
    	{
    	sprintf(buffer, "%d %s -  %d %s  %d",
    						initial_hebrew_day, initial_hebrew_month,
    					    final_hebrew_day, final_hebrew_month, final_hebrew_year);

     	p.eraseRect( ((this->width()-300)/-2), 30, (this->width()-300), 30);
			p.drawText( -100, 30, 200, 17, AlignCenter, buffer, -1);
			p.end();
			}
    else
    	// we've crossed a year boundary
    	{
    	sprintf(buffer, "%d %s %d -  %d %s %d",
    					    initial_hebrew_day, initial_hebrew_month, initial_hebrew_year,
    					    final_hebrew_day, final_hebrew_month, final_hebrew_year);
     	p.eraseRect( ((this->width()-300)/-2), 30, (this->width()-300), 30);
			p.drawText( -100, 30, 200, 17, AlignCenter, buffer, -1);
			p.end();
			}
}
void Kluach::FillInMonth( char *month_name )
{
	QPainter p;
	QPen pen( black, 1);
  p.begin( this );
	p.setPen( pen );
	p.setFont( QFont( "times", 12, QFont::Bold ) );
	p.translate( (this->width()/2), 30 );
	char buffer[150];	
	sprintf( buffer, "%s %d", month_name, year );
	p.eraseRect( ((this->width()-300)/-2), 0, (this->width()-300), 30);
	p.drawText( -100, 10, 200, 17, AlignCenter, buffer, -1);
	p.end();

}
void Kluach::DoTheOutput( int column, int row, int day, int j_year, char *j_month_name, int j_day, char **holidays )
{
	QPainter p;
	QPen pen( black, 1);
	if (JulianP) pen.setColor(red);
	p.begin( this );
	p.setPen( pen );
	
	int		top, left;
	char  buffer[200];

	// Figure where this information goes in the calendar.
  int calendarWidth=this->width()-6;
	int calendarHeight=this->height()-108;
	int dateBoxWidth=calendarWidth/7;
	int dateBoxHeight=calendarHeight/6;
	top	= 108 + row * dateBoxHeight;
	left = 3 + (column) * dateBoxWidth;
	QRect box( left, top, dateBoxWidth + 1, dateBoxHeight + 1);
	p.eraseRect( box );

	// Print the secular day of the month in bold
	p.setFont( QFont( "times", 12, QFont::Bold ) );
	sprintf(buffer, "%d", day);
	p.drawText( left, top+2, dateBoxWidth + 1, dateBoxHeight -1, AlignHCenter | AlignTop, buffer);

	
	// Print the Hebrew day just below it
		p.setFont( QFont( "times", 12 ) );		
		sprintf(buffer, "%d %s", j_day, j_month_name);
		p.drawText( left, top+12, dateBoxWidth + 1, dateBoxHeight -11, AlignHCenter | AlignTop, buffer);
	
	if (holidays[1] != NULL) {
		// If there are more than two holidays, print both of them
		sprintf(buffer, "%s", holidays[0]);
		int fontSize;
		if ((strlen(buffer)) > 15)
		{
		fontSize=10;
		}
		else fontSize=12;
		p.setFont( QFont( "times", fontSize ) );		
		p.drawText( left, top+22, dateBoxWidth + 1, dateBoxHeight -21, AlignHCenter | AlignTop, buffer);
		sprintf(buffer, "%s", holidays[1]);
		if ((strlen(buffer)) > 15)
		{
		fontSize=10;
		}
		else fontSize=12;
		p.setFont( QFont( "times", fontSize ) );		
		p.drawText( left, top+32, dateBoxWidth + 1, dateBoxHeight -31, AlignHCenter | AlignTop, buffer);
	} else if (holidays[0] != NULL) {
		sprintf(buffer, "%s", holidays[0]);

		int fontSize;
		if ((strlen(buffer)) > 15)
		{
		fontSize=10;
		}
		else fontSize=12;
		p.setFont( QFont( "times", fontSize ) );		
		p.drawText( left, top+22, dateBoxWidth + 1, dateBoxHeight -21, AlignHCenter | AlignTop, buffer);
		
	}
	// Draw a line around the box	
  p.drawRect(box);

	p.end();
}

void Kluach::DrawGrid()
{
QPainter p;
QPen pen( gray, 1 /*, DashLine*/);
p.begin( this );
p.setPen( pen );

	
int		top, left;

// Figure where this information goes in the calendar.
int calendarWidth=this->width()-6;
int calendarHeight=this->height()-108;
int dateBoxWidth=calendarWidth/7;
int dateBoxHeight=calendarHeight/6;
	
for (int row=0; row < 6; row++)
{  	
	for (int column=0; column < 7; column++)
	{
      	top	= 108 + row * dateBoxHeight;
      	left = 3 + (column) * dateBoxWidth;
      	QRect box( left, top, dateBoxWidth + 1, dateBoxHeight + 1);
      	p.drawRect(box);
   }
}


	p.end();
}
