/***************************************************************************
                          kluach.h  -  description
                             -------------------
    begin                : Fri May  5 00:50:08 EDT 2000
    copyright            : (C) 2000 by Jonathan Singer
    email                : jsinger@leeta.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software and can be used or redistributed        *
 *   subject to the included license.                                      *
 *                                                                         *
 ***************************************************************************/

#ifndef KLUACH_H
#define KLUACH_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <ktmainwindow.h>
#include <setyear.h>
extern "C" {
#include <Converter.h>
#include <Holiday.h>
}

#ifndef BOOLEAN
#define BOOLEAN
typedef unsigned int Boolean;
#endif


class Kluach : public QWidget
{
  Q_OBJECT
  public:
    /** constructor */
    Kluach(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~Kluach();
    void openYeardialog();
  	void setJulianP( bool );
  	void setIsraelP( bool);
  	void yearSet( int );
  public slots:
    /** menu handlers **/
    void optionsmenuHandler( int );
    void monthmenuHandler( int );
    void yearmenuHandler( int );

  	void advanceYear();
  	void decreaseYear();
  	void advanceMonth();
  	void decreaseMonth();
  	void resetYear( int );
	protected:
		void paintEvent( QPaintEvent *);
		void FillInCalendar( int, int );
		void FillInMonth( char * );
		void DoTheOutput( int, int, int, int, char *, int, char ** );
		void openYearDialog();
		void DrawGrid();
		void WriteSettings();

	private:
		int year;
		int month;
		bool JulianP;
		bool IsraelP;
		bool Parsha;
		bool Omer;
		bool CholHaMoed;
		int dateBoxWidth;
		int dateBoxHeight;
		
		KMenuBar  *menu;
		KPopupMenu *filemenu;
		KPopupMenu *optionsmenu;
		KPopupMenu *monthmenu;
		KPopupMenu *yearmenu;
		QPushButton *previous;
		QPushButton *next;
		KHelpMenu *khelp;
				
		
		setYear *setyear;
		
		int PRINT, QUIT;
		
	
		
		
	
};

#endif
