//==========================================================================
//
//   SelRect.h
//
//==========================================================================

#include <X11/Xlib.h>

#include <qrect.h>
#include <qwidget.h>

class SelRect : public QObject, public QRect
{
    Q_OBJECT
    
public:
    SelRect(QWidget *parent=0);
    SelRect(const QPoint &topleft, const QPoint &bottomright,
	    QWidget *parent=0);
    SelRect(const QPoint &topleft, const QSize &size,
	    QWidget *parent=0);
    SelRect(int left, int top, int width, int height,
	    QWidget *parent=0);

    virtual ~SelRect();

    bool visible();
    
public slots:	

    void show();
    void hide();
    void update();

signals:

    void updated();
    
protected:

    void init(QWidget *);
    void paint(const QRect &);
    
    GC gc;
    QWidget *parent;
    bool isVisible;
    QRect old;

};

class SelRectHider
{
    
public:
    
    SelRectHider(SelRect &_selRect);
    ~SelRectHider();
    
protected:
    
    SelRect &selRect;
    bool hidden;
};

//--------------------------------------------------------------------------
//   end of file
//--------------------------------------------------------------------------

