#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>

#include <qmsgbox.h>
#include <qdatetime.h>

#include "memdata.h"
#include "../kernel/memmap.h"

/* TODO: make reading in of data _not_ one byte at a time */ 

MemData::MemData(QWidget *parent, const char *name)
	: QObject(parent, name), fd(-1), pages(0),
		number_of_pages(0), update_time(1000)
{
#define datafile	"/dev/memmap"

	fd = open( datafile, O_RDONLY ) ;

	if ( fd==-1 )
	{
		QString tmp;
		tmp.sprintf( i18n("Could not open file %s (errno %d)."
				" Have you installed the kernel module?"),
				datafile, errno ) ;
 		QMessageBox::warning( parent, PACKAGE, tmp.data() ) ;
	}
	else
	{
		printf( i18n("Opened %s succesfully!\n"),
				datafile ) ;

		int result ;

		result = ioctl( fd, MEMMAP_IOCTL_GET_NR_OF_PAGES,
					&number_of_pages ) ;

		if ( result!=0 ) 	/* ioctl() went wrong */
		{
			QString tmp;
			tmp.sprintf( i18n("Could not ioctl %s. Unable "
				"to do more for you..."), datafile ) ;
			QMessageBox::warning( parent, PACKAGE, tmp.data() ) ;
			close(fd) ;
			fd=-1;
			number_of_pages=0;
		}
		else	/* ioctl() was ok */
		{
			pages = new char [number_of_pages] ;

			printf( i18n("You seem to have %d "
					"pages in your memory!\n"),
						number_of_pages ) ;
	 	}
	}

	readData() ;

	setUpdateTime( update_time ) ;
}

MemData::~MemData()
{
	#ifdef DEBUG
	printf("Deleting MemData\n");
	#endif
	/* TODO
	if (fd>0)
		close(fd) ;
	*/
}

void MemData::setUpdateTime( int s ) 
{
	update_time = s ;
	killTimer( timer_id ) ;
	timer_id = startTimer( update_time ) ;
}

int MemData::updateTime() const
{
	return update_time ;
}

void MemData::timerEvent( QTimerEvent * )
{
	readData() ;
	emit dataChanged() ;
}

const char * MemData::getPagePointer()
{
	return (const char *)pages ;
}

char MemData::getPage( int p ) const 
{
	if ( pages!=0 && p>=0 && p < numberOfPages() )
		return pages[p] ;
	else	return 0 ; 
}

char MemData::getPageNoCheck( int p ) const
{
	return pages[p] ;
}

void MemData::readData()
{
	if( (fd==-1) || (pages==0) ) return ;

	#ifdef DEBUG 
	//QTime t ;
	//t.start() ;
	#endif
 
/*
	// old implementation
	for( int i=0;i<numberOfPages();i++)
		pages[i]=readPage(i) ;
*/


	lseek( fd, 0, SEEK_SET ) ;

	int count = numberOfPages() ;
	int pos=0 ;
	int x;

	while( count )
	{
	 	x = read( fd, pages+pos, count ) ;
		if ( x!=-1 )
		{
			pos+=x ;
			count-=x;
		}
		else	break ;
	}

	#ifdef DEBUG
	//printf("MemData::readData() time : %d\n", t.elapsed() ) ;
	#endif
}

char MemData::readPage( int p )
{
	#ifdef DEBUG
	//printf("MemData::readPage()\n");
	#endif
	
	/* we already assume the filedescriptor fd  is ok. */
	/* we assume the argument p is correct */

	/* first find the data */
	lseek( fd, p, SEEK_SET ) ;
	char buf ;
	read( fd, &buf, 1 ) ;

	return buf ;
}


/* inline int MemData::numberOfPages() const ; */

int MemData::toFile( int pos )
{
	return pos ;
}

int MemData::fromFile( int pos )
{
	return pos ;
}

