/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef LOADDLG_H 
#define LOADDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qprogressdialog.h>
#include <qwidget.h>

#include "modem.h"


typedef struct mlo_config_t {
	char firmware[41];		/* ATI3		*/

	int country;			/* AT+GCI	*/

	int mem_free;			/* AT$JMEM=Free	*/

	bool fax_takeover;		/* AT$JCFGF	*/
	bool call_accept;

	bool announce_system;		/* AT$JCFGM	*/
	bool announce_number;
	bool announce_time;
	int outgoing_message;

	bool fax_operation;		/* AT$JCFGT	*/
	bool voice_operation;
	bool voice_recording;
	bool hook_config;
	bool keyboard_config;
	bool operation_control;

	int max_rec_time;		/* AT$JCFGV	*/
	int min_rec_time;
	char rec_quality[9];
	bool rec_speaker;
	bool rec_monitor;

	char fax_id[21];		/* AT$JFLI	*/

	bool remote_query;		/* AT$JPWD	*/
	bool remote_config;
	char remote_pw[5];

	int ring_number;		/* AT$JRING	*/
	bool ring_signal;
	bool ring_suppress_ri;
	bool ring_fixed;

	int voice_rec;			/* AT$JVGR	*/
	int voice_play;			/* AT$JVGT	*/
	int voice_micro;		/* AT$JVGM	*/
	int voice_speaker;		/* AT$JVGS	*/

	int year, month, day;		/* AT$JDATE	*/

	int hour, minute, second;	/* AT$JTIME	*/

	bool sync_timer;
};


class LoadDlg : public QProgressDialog
{
	Q_OBJECT
public:
	LoadDlg( QWidget * parent = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0 );
	~LoadDlg();

	void setDefaultConfig();
	mlo_config_t * getConfig();
	void setConfig( mlo_config_t * conf );

	bool startDownload( const char * device, int speed );
	bool startUpload( const char * device, int speed );

public slots:
	void cancel();

private slots:
	void fetchModemLineDown( const char * line );
	void fetchModemLineUp( const char * line );
	void fetchTimeout();

private:
	void init();
	void reset();

	mlo_config_t c;

	Modem * modem;
	int status;

signals:
	void downDone( bool );
	void upDone( bool );
};


#endif // LOADDLG_H
