/*
    KMLOCfg
    
    A utility to configure the ELSA MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef SETUPDLG_H 
#define SETUPDLG_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qtabdialog.h>
#include <qwidget.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#undef Above		// Avoid Qt <-> X11 conflict
#undef Below
#include <qslider.h>

#include "loaddlg.h"


class SetupDlg : public QTabDialog
{
	Q_OBJECT
public:
	SetupDlg( QWidget * parent = 0, const char * name = 0 );
	virtual ~SetupDlg();

	void addToolTips( bool on );

public slots:
	mlo_config_t * getConfig();
	void setConfig( mlo_config_t * conf );
	void reset();
	void apply();

signals:
	void apply_clicked();

private:
	bool gotToolTips;

	mlo_config_t c;

	QWidget * page1, * page2, * page3, * page4;

	QLabel * general_firmware, * general_time;
	QCheckBox * general_sync;
	QComboBox * general_country;
	QCheckBox * general_ring;
	QComboBox * general_rings;
	QCheckBox * general_acceptearly, * general_acceptfull, * general_acceptdtr, * general_suppressri;

	QCheckBox * answer_enabled, * answer_record;
	QComboBox * answer_outgoing;

	QSlider * rec_playvol, * rec_recvol;
	QComboBox * rec_quality, * rec_maxdur, * rec_mindur;
	QCheckBox * rec_speaker;

	QCheckBox * fax_operation, * fax_takeover;
	QLineEdit * fax_id;

	QCheckBox * message_system, * message_number, * message_time;

	QSlider * speaker_volume, * speaker_micro;
	QCheckBox * speaker_monitor;

	QCheckBox * access_hook, * access_dtmf;
	QCheckBox * access_playback, * access_config;
	QLineEdit * access_password;
};


#endif // SETUPDLG_H
