/*
    KMLOFax
    
    A utility to process facsimile received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 1999-2000 Oliver Gantz <o.gantz@tu-bs.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
    PostScript(R) is a registered trademark of Adobe Systems Incorporated.
*/

#ifndef PRINTDLG_H
#define PRINTDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <stdio.h>

#include <qstring.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>

#include "mlofile.h"




class MLO2PSFilter
{
public:
	MLO2PSFilter( const char * infile );
	~MLO2PSFilter();

	void setFormat( int format );
	void setInterpolate( bool interp );
	void setRange( int first, int last );
	void setCopies( int copies );
	void setMargins( int left, int right, int top, int bottom );

	bool convertFile( FILE * stream, const char * sender );

private:
	bool convertPage( int fax_page, int sub_page, int ps_page, int lines, int strech_y );

	void writeBase85( uchar c );
	void flushBase85();

	void writeImageData( char c );
	void flushImageData();

	void resetImageData();

	MLOFile mlofile;

	FILE * ps;

	int paper_x, paper_y;
	bool interpolate;
	int first_page, last_page;
	int doc_copies;
	int l_margin, r_margin, t_margin, b_margin;

	int size_x, size_y;
	int view_x, view_y;
	int scale_x, scale_y;
	int trans_x, trans_y;

	uchar base85_buff[4];
	int base85_ind;

	char image_buff[254];
	int image_ind;
};




class PrintDlg : public QDialog
{
	Q_OBJECT
public:
	PrintDlg( QWidget * parent = 0, const char * name = 0 );
	virtual ~PrintDlg();

	void addToolTips( bool on );

	void printFax( const char * name, const char * alias );

private slots:
	void okClicked();

	void destinationSelected( int id );
	void formatSelected( int id );

private:
	bool gotToolTips;

	bool to_printer;
	int paper_num;

	QButtonGroup * destination;
	QLineEdit * printer;
	QLineEdit * file;

	QSpinBox * from_page;
	QSpinBox * to_page;
	QSpinBox * copies;
	QCheckBox * interpolate;

	QButtonGroup * paper_format;

	char * fname, * salias;
};


extern PrintDlg * printdlg;

#endif // PRINTDLG_H
