#include "MySql++.h"

RefCounter MySqlResult::refCounter;

// MySqlClient

MySqlClient::MySqlClient(void)
  {
  connected = false;
  }

MySqlClient::~MySqlClient(void)
  {
  if(connected)
    mysql_close(&mysql);
  }

int MySqlClient::connect(const char *host, const char *username, const char *password)
  {
  if(mysql_connect(&mysql, host, username, password))
    {
    connected = true;
    return 1;
    }
  else
    return 0;
  }

void MySqlClient::close(void)
  {
  mysql_close(&mysql);
  connected = false;
  }

int MySqlClient::selectDB(const char *basename)
  {
  return mysql_select_db(&mysql, basename);
  }

int MySqlClient::query(const char *query)
  {
  return mysql_query(&mysql, query);
  }

char *MySqlClient::error(void)
  {
  return mysql_error(&mysql);
  }

MySqlResult MySqlClient::storeResult(void)
  {
  MYSQL_RES *r = mysql_store_result(&mysql);
  MySqlResult res(r);
  return res;
  }

int MySqlClient::affectedRows(void)
  {
  return mysql_affected_rows(&mysql);
  }

int MySqlClient::createDB(const char *dbname)
  {
  return mysql_create_db(&mysql, dbname);
  }

int MySqlClient::dropDB(const char *dbname)
  {
  return mysql_drop_db(&mysql, dbname);  
  }

MySqlResult MySqlClient::listFields(const char *table, const char *wild)
  {
  MYSQL_RES *r = mysql_list_fields(&mysql, table, wild);
  MySqlResult res(r);
  return res;
  }

MySqlResult MySqlClient::listDbs(const char *wild)
  {
  MYSQL_RES *r = mysql_list_dbs(&mysql, wild);
  MySqlResult res(r);
  return res;
  }

MySqlResult MySqlClient::listTables(const char *wild)
  {
  MYSQL_RES *r = mysql_list_tables(&mysql, wild);
  MySqlResult res(r);
  return res;
  }

int MySqlClient::shutdown(void)
	{
	return mysql_shutdown(&mysql);
	}

char *MySqlClient::serverInfo(void)
	{
	return mysql_get_server_info(&mysql);
	}
	
char *MySqlClient::hostInfo(void)
	{
	return  mysql_get_host_info(&mysql);
	}

unsigned int MySqlClient::protoInfo(void)
	{
	return mysql_get_proto_info(&mysql);
	}

int MySqlClient::reload(void)
	{
	return mysql_reload(&mysql);
	}

char *MySqlClient::stat(void)
	{
	return mysql_stat(&mysql);
	}

MySqlResult MySqlClient::listProcesses(void)
	{
	MYSQL_RES *r = mysql_list_processes(&mysql);
  MySqlResult res(r);
  return res;
	}

// MySqlResult

MySqlResult::MySqlResult(void)
  {
  res = 0;
  }

MySqlResult::MySqlResult(MYSQL_RES *ares)
  {
  res = ares;
  if(!refCounter.exists(res))
  	refCounter.add(res);
  refCounter.increase(res);
  }

MySqlResult::MySqlResult(const MySqlResult &other)
  {
  res = other.res;
  if(res != 0)
  	refCounter.increase(res);
  }

MySqlResult::~MySqlResult(void)
  {
  if(res)
  	{
  	refCounter.decrease(res);
  	if(refCounter.count(res) == 0)
  		{
    	mysql_free_result(res);
    	refCounter.remove(res);
    	}
    }
  }

MySqlRow MySqlResult::fetchRow(void)
  {
  MYSQL_ROW r;
  r = mysql_fetch_row(res);
  MySqlRow row(r);
  return row;
  }

MySqlField *MySqlResult::fetchField(void)
  {
  return mysql_fetch_field(res);
  }

int MySqlResult::numFields(void)
  {
  return mysql_num_fields(res);
  }

int MySqlResult::numRows(void)
  {
  return mysql_num_rows(res);
  }

void MySqlResult::dataSeek(uint offset)
  {
  mysql_data_seek(res, offset);
  }

int MySqlResult::eof(void)
  {
  return mysql_eof(res);
  }

MySqlResult::operator void*(void)
  {
  return res;
  }

// MySqlRow

MySqlRow::MySqlRow(void)
  {
  }

MySqlRow::MySqlRow(MYSQL_ROW arow)
  {
  row = arow;
  }

char *MySqlRow::operator[](int index)
  {
  return row[index];
  }

MySqlRow::operator void*(void)
  {
  return row;
  }


