/*
 * 		This file contains an implementation of the command
 *		that maintains the kernel's ARP cache.  It is derived
 *		from Berkeley UNIX arp(8), but cleaner and with sup-
 *		port for devices other than Ethernet.
 *
 * code take from:  arp 1.83 (1998-02-13)
 * Maintainer:	Bernd 'eckes' Eckenfels, <net-tools@lina.inka.de>
 * Author: 	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *
 * Modified for Knetdump: Norbert Weuster <weuster@uni-duisburg.de>
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include "knetdumpdoc.h"
#define _PATH_PROCNET_ARP              "/proc/net/arp" 

/* Delete an entry from the ARP cache. */
int KnetdumpDoc::arp_del(char *name, int sockfd) {
  char host[128];
  struct arpreq req;
  struct sockaddr sa;
  struct sockaddr_in *sin;
  int flags=0;
  int err;

  memset((char *) &req, 0, sizeof(req));

  host[(sizeof host)-1] = 0;
  strncpy(host, name, (sizeof host)-1);

  sin=(struct sockaddr_in *) &sa;
  sin->sin_family= AF_INET;
  sin->sin_port= 0;
  inet_aton(name, &sin->sin_addr);

  //req.arp_dev="eth0";
    
  /* If a host has more than one address, use the correct one! */
  memcpy((char *) &req.arp_pa, (char *) &sa, sizeof(struct sockaddr));

  req.arp_flags=ATF_PERM;
  flags = 3;
  //char device[16]="";			/* current device		*/
  //strcpy(req.arp_dev,device);
  err = -1;

  /* Call the kernel. */
  if (flags & 2) {
  	if ((err = ioctl(sockfd, SIOCDARP, &req) < 0)) {
		if (errno == ENXIO) {
			if (flags & 1)
				goto nopub;
			cerr << "No ARP entry for " << host << endl;
			return(-1);
		}
		perror("SIOCDARP(priv)");
		return(-1);
  	}
  }
  if ((flags & 1) && (err)) {
nopub:
  	req.arp_flags |= ATF_PUBL;
  	if (ioctl(sockfd, SIOCDARP, &req) < 0) {
		if (errno == ENXIO) {
                    cerr << "No ARP entry for " << host << endl;
			return(-1);
		}
		perror("SIOCDARP(pub)");
		return(-1);
  	}
  }

  return(0);
}

/* Display the contents of the ARP cache in the kernel. */
int KnetdumpDoc::arp_show(int sockfd) {
  char host[100];
  // struct sockaddr sa;
  char ip[100];
  char hwa[100];
  char mask[100];
  char line[200];
  char dev[100];
  int type,flags;
  FILE *fp;
  int num,entries=0,showed=0;

  host[0]='\0';
  
  /* Open the PROCps kernel table. */
  if ((fp = fopen(_PATH_PROCNET_ARP, "r")) == NULL) {
      perror(_PATH_PROCNET_ARP);
      return(-1);
  }

  /* Bypass header -- read until newline */
  if (fgets(line, sizeof(line), fp) != (char *)NULL) {
	strcpy(mask,"-");
	strcpy(dev,"-");
	/* Read the ARP cache entries. */
	for(;fgets(line,sizeof(line),fp);)
	{
		num=sscanf(line,"%s 0x%x 0x%x %100s %100s %100s\n",
		                               ip,&type,&flags,hwa,mask,dev);
		if(num<4)
			break;
		entries++;	
		showed++;

                arp_del(ip, sockfd);
        }
  }
  printf("Entries: %d\tSkipped: %d\tFound: %d\n",entries,entries-showed,showed);
  
  if (!showed) {
  	if (host[0])
            cerr << host << " -- no entry\n";
  	else if (host[0] || dev[0]) {
            cerr << "arp: in " << entries << " entries no match found.\n";
 	}
  }
  (void) fclose(fp);
   return(0);
}
