/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSTATSVIEW_H
#define KSTATSVIEW_H

#include <qwidget.h>
#include <qlistview.h>
#include <sys/time.h>
#include <kcombo.h>

#include "knetdumpdoc.h"

/**View class for displaying Statistics
  *@author Norbert Weuster
  */

class KStatsView : public QListView  {
   Q_OBJECT
public: 
	KStatsView(QWidget *parent=0, KnetdumpDoc* doc=0, const char *name=0);
	~KStatsView();

	void draw();

private:
	
public slots:
 void startslot ();
 void slotChangeInterface(QString); 

protected slots:
       void timerDone();

signals:
 void gotData();
 void showToolBar();

public:
  QString interface;

private:
  bool drawing;
  KnetdumpDoc *pdoc;
  QTimer *activitytimer;

  //QString *timerstr;
  unsigned long starttime;
  struct timeval tv;
  float peakactivity;
  float peakpps;
  float spanbr;
  float spanpkt;

  QListViewItem *packetitem;
  QListViewItem *ipitem;
  QListViewItem *tcpitem;
  QListViewItem *udpitem;
  QListViewItem *icmpitem;
  QListViewItem *otheripitem;
  QListViewItem *arpitem;
  QListViewItem *rarpitem;
  QListViewItem *badipitem;
  QListViewItem *othersitem;
  QListViewItem *appleitem;
  QListViewItem *netbiositem;
  QListViewItem *ipxitem;            

};

#endif
