/***************************************************************************
                          netheader.h  -  description                              
                             -------------------                                         
    begin                : Wed Mai 22 1999                                           
    copyright            : (C) 1999 by Norbert Weuster                         
    email                : weuster@uni-duisburg.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

///////////////////////////////////////////////////////////////
// special netheaders

#ifndef NETHEADER_H
#define NETHEADER_H

#include <netinet/if_ether.h>
#include <sys/types.h>

struct ether802hdr {
      u_int8_t  ether_dhost[ETH_ALEN];      /* destination eth addr */
      u_int8_t  ether_shost[ETH_ALEN];      /* source ether addr    */
      u_int16_t length;                     /* length of following bytes sans CRC */
      u_int8_t dsap;                        /* LLC  */
      u_int8_t ssap;                        /* LLC  */
      u_int8_t cntl;                        /* LLC  */
      u_int8_t org_code[3];                   /* SNAP */
      u_int16_t ether_type;                 /* SNAP, packet type ID field */
};
  
struct ppphdr {
      u_int8_t flag;                // should be 0x7E   // notwendig??? // TODO
      u_int8_t addr;                // should be 0xff 
      u_int8_t control;             // should be 0x02 
      u_int16_t protocol;           // 0x0021 for ip data, 0xc021 for link control data 
};				   //   0x8021 for network control data ...

struct netbioshdr {
    u_int16_t length;
    u_int16_t efff;
    u_int8_t cmd;
    u_int8_t opt1;
    u_int16_t opt2;
    u_int32_t xr;
};

struct ipxhdr {
     u_int16_t check;
     u_int16_t length;
     u_int8_t transpctrl;
     u_int8_t packettype;
     u_int32_t dnetwork;
     u_int8_t dhost[ETH_ALEN];
     u_int16_t dsocket;
     u_int32_t snetwork;
     u_int8_t shost[ETH_ALEN];
     u_int16_t ssocket;
};

struct spxhdr {
     u_int8_t connctrl;
     u_int8_t datastreamtype;
     u_int16_t sconnid;
     u_int16_t dconnid;
     u_int16_t seq;
     u_int16_t ack;
     u_int16_t allocation;
};

#endif NETHEADER_H

