#include "adddialog.moc"

#include <kapp.h>
#include <klocale.h>

#include <qpushbutton.h> 
#include <qlabel.h>
#include <qlineedit.h> 

CAddDialog::CAddDialog(QWidget* parent, const char* name) : QDialog(parent, name, TRUE)
{
  setCaption("Add Server");

  fStaticServer = new QLabel(i18n("Enter new server address:"), this, "StaticServer");
  fStaticServer->setGeometry(10, 10, 180, 20);

  fServer = new QLineEdit(this, "Server");
  fServer->setGeometry(10, 35, 180, 25);
  fServer->setText("");

  fOk = new QPushButton(i18n("&Ok"), this, "Ok");
  fOk->setGeometry(40, 70, 50, 25);

  connect(fOk, SIGNAL(clicked()), this, SLOT(accept()));

  fCancel = new QPushButton(i18n("&Cancel"), this, "Cancel");
  fCancel->setGeometry(110, 70, 50, 25);

  connect(fCancel, SIGNAL(clicked()), this, SLOT(reject()));
}

CAddDialog::~CAddDialog()
{
  disconnect(fOk, SIGNAL(clicked()), this, SLOT(accept()));
  disconnect(fCancel, SIGNAL(clicked()), this, SLOT(reject()));

  delete(fStaticServer);
  delete(fServer);
  delete(fOk);
  delete(fCancel);
}

char* CAddDialog::ServerName()
{
  return (char*)fServer->text();
}
