#include <iostream.h>

// QT Headers
#include <qtimer.h>

#include "clientmanager.h"
#include "knewmail.h"
#include "knewmailengine.h"

KNewMailEngine::KNewMailEngine(QList<ServerStruct>* mailboxList, QWidget *parent, const char *name) : QObject(parent, name)
{
  
  fMailboxList = mailboxList;

  // Setup the headerlist QList. Since all the header structs end up in the 
  // full headerlist, we don't need to worry about setting the others to
  // autoDelete
  fFullHeaderList.setAutoDelete( TRUE );
  fCurrentHeaderList.setAutoDelete( FALSE );
  fNewMsgHeaderList.setAutoDelete( FALSE );

  // Create the Pop Manager
  fClientManager = new ClientManager(parent);

  // Setup the timer
  fCheckMailTimer = new QTimer(this, "CheckMailTimer");
  connect(fCheckMailTimer, SIGNAL( timeout() ), this, SLOT( slotCheckMail() ));
  initCheckMailTimer();
 
}

KNewMailEngine::~KNewMailEngine()
{
  delete(fClientManager);
}

void KNewMailEngine::initCheckMailTimer()
{
  KConfig* config = kapp->getConfig();

  config->setGroup("BASE");
  fCheckMailTimer->start(config->readNumEntry("CheckTime", 5)*60000, TRUE);
}

void KNewMailEngine::checkMail()
{
  bool changedActive = FALSE;
  KConfig* config = kapp->getConfig();

  config->setGroup("BASE");

  if (!config->readBoolEntry("Active", FALSE))
    {
      config->writeEntry("Active", TRUE);
      changedActive = TRUE ;
    }

  fCheckMailTimer->stop();
  slotCheckMail();

  config->setGroup("BASE");
  if (changedActive)
    config->writeEntry("Active", FALSE);
}
     
void KNewMailEngine::configDialogActivated(int state)
{
  switch(state)
    {
    case CONFIG_DIALOG_OPENED:
      fCheckMailTimer->stop();
      break;

    case CONFIG_DIALOG_CLOSED:
      initCheckMailTimer();
      break;
    }
}

void KNewMailEngine::processLists(QList<HeaderStruct>* currentHeaderList, QList<HeaderStruct>* newMsgHeaderList, QList<HeaderStruct>* fullHeaderList)
{
  bool found = FALSE;
  QListIterator<HeaderStruct> currentHeaderListIter(*currentHeaderList);
  QListIterator<HeaderStruct> fullHeaderListIter(*fullHeaderList);

  HeaderStruct* currentListHeaderInfo;
  HeaderStruct* fullListHeaderInfo;
  
  bool isSmaller = FALSE;
  int index = 0;

  // clear the new message header list
  newMsgHeaderList->clear();

  // get the first current list header info
  currentListHeaderInfo = currentHeaderListIter.toFirst();

  // for each one of the items in the currentHeaderList we need to search
  // through the fullheaderlist to see if it alread exists.
  while (currentListHeaderInfo != NULL)
    {
      fullListHeaderInfo = fullHeaderListIter.toFirst();
      while ((fullListHeaderInfo != NULL) && (!found))
	{
	  if ((fullListHeaderInfo->from == currentListHeaderInfo->from) && (fullListHeaderInfo->datetime == currentListHeaderInfo->datetime))
	    found = TRUE;
	  
	  else
	    fullListHeaderInfo = ++fullHeaderListIter;
	}

      if (!found)
	newMsgHeaderList->append(currentListHeaderInfo);

      found = FALSE;
      currentListHeaderInfo = ++currentHeaderListIter;
    }

  // now that we are done all that, we will clear the original
  // full header list and copy over the current one.
  fullHeaderList->clear();

  currentListHeaderInfo = currentHeaderListIter.toFirst();
  while (currentListHeaderInfo != NULL)
    {
      fullListHeaderInfo = fullHeaderList->first();
      index = 0;
      isSmaller = FALSE;
      while ((fullListHeaderInfo != NULL) && (!isSmaller))
	{
	  if (currentListHeaderInfo->datetime < fullListHeaderInfo->datetime)
	    isSmaller = TRUE;

	  if (!isSmaller)
	    {
	      index++;
	      fullListHeaderInfo = fullHeaderList->next();
	    }
	}

      fullHeaderList->insert( index, currentListHeaderInfo );
      
      currentListHeaderInfo = ++currentHeaderListIter;
    }

  currentHeaderList->clear();
}


/////////////////////////////////////////////////////////
////////////////// SLOTS ///////////////////////////////

void KNewMailEngine::slotCheckMail()
{
  ServerStruct* serverInfo;
  QListIterator<ServerStruct> mailboxListIter(*fMailboxList);

  KConfig* config=kapp->getConfig();
  config->setGroup("BASE");
  if (config->readBoolEntry("Active", FALSE))   // If active, do this stuff
    {
      
      // -- BEGIN CHECKING ----------------------
      
      serverInfo = mailboxListIter.toFirst();

      while (serverInfo != NULL)
	{
	  //cout << "Checking Mail: " << serverInfo->address << endl;
	    
	  fClientManager->checkMail(&fCurrentHeaderList, serverInfo);

	  // moving to next mailbox
	  serverInfo = ++mailboxListIter;
	}

      processLists(&fCurrentHeaderList, &fNewMsgHeaderList, &fFullHeaderList);

      // -- END CHECKING ------------------------

      // Once done, emit check performed signal
      emit checkPerformed(&fFullHeaderList, &fNewMsgHeaderList);
    }

  //restart timer.
  initCheckMailTimer();
}



#include "knewmailengine.moc"
