// KDE headers
#include <kconfig.h>
#include <kapp.h>

// QT headers

#include <iostream.h>

// Homemade headers
#include "listview.h"
#include "knewmailview.h"

KNewMailView::KNewMailView(QWidget *parent, const char *name)
	: QWidget(parent, name)
{

  createListViewWidget();

}

KNewMailView::~KNewMailView()
{
  delete( fListView);
}

void KNewMailView::createListViewWidget()
{
   fListView = new CListView(this, "ListView");
   fListView->setSize(width(), height());
   fListView->show();
   fListView->setSorting (-1, TRUE );
   fListView->setAllColumnsShowFocus( true );
   connect(fListView, SIGNAL( doubleClicked(QListViewItem*)), this, SLOT(slotLeftButtonDoubleClicked(QListViewItem*)));
  connect(fListView, SIGNAL( rightButtonClicked(QListViewItem*, const QPoint&, int)), this, SLOT(slotRightButtonClicked(QListViewItem*, const QPoint&, int) ) );

   // Insert a blank entry.
   QListViewItem* listViewItem;
   listViewItem = new QListViewItem(fListView, "");
}

void KNewMailView::refresh()
{
  //destroy the list view widget
  fListView->hide();
  fListView->clear();
  //disconnect(fListView, SIGNAL( doubleClicked(QListViewItem*)), this, SLOT(slotListItemDoubleClicked(QListViewItem*)));
  //disconnect(fListView, SIGNAL( rightButtonClicked(QListViewItem*, const QPoint&, int)), this, SLOT(slotActivatePopupMenu(QListViewItem*, const QPoint&, int) ) );
  delete(fListView);

  // now recreate it.
  createListViewWidget();
}

void KNewMailView::displayHeaderList(QList<HeaderStruct>* headerList)
{
  HeaderStruct *headerInfo;
  QListViewItem* listViewItem;
  KConfig* config = kapp->getConfig();

  // Clear the current view.
  fListView->clear();

  // If the list is empty, just insert a blank entry.
  if (headerList->count() == 0)
    {
      listViewItem = new QListViewItem(fListView, "");
    }

  else
    {
      headerInfo = headerList->first();
      config->setGroup("VIEW");

      switch(config->readNumEntry("ToFieldType", TO_TYPE_ADDRESS))
	{
	case TO_TYPE_DISABLED:
	  
	  while (headerInfo != NULL)
	    {
	      listViewItem = new QListViewItem(fListView, headerInfo->from, headerInfo->subject);
	      headerInfo = headerList->next();
	    }
	  break;

	case TO_TYPE_PARSED:
	  
	  while (headerInfo != NULL)
	    {
	      listViewItem = new QListViewItem(fListView, headerInfo->to, headerInfo->from, headerInfo->subject);
	      headerInfo = headerList->next();
	    }
	  break;

	default:    // TO_TYPE_ADDRESS
		 	  
	  while (headerInfo != NULL)
	    {
	      listViewItem = new QListViewItem(fListView, headerInfo->address, headerInfo->from, headerInfo->subject);
	      headerInfo = headerList->next();
	    }
	  break;
	}
    }
}  
void KNewMailView::resizeEvent(QResizeEvent *evt)
{
    QWidget::resizeEvent(evt);

    fListView->setSize(width(), height());

    // QRect r = this->geometry();
    // [your_main_widget]->resize(r.width(),r.height());

}

void KNewMailView::saveOptions()
{
  fListView->saveOptions();
}


////////////////////////////////////////////////
///////////////// SLOTS ////////////////////////
void KNewMailView::slotLeftButtonDoubleClicked(QListViewItem*)
{
  emit leftButtonDoubleClicked();
}

void KNewMailView::slotRightButtonClicked(QListViewItem*, const QPoint& point, int)
{
  emit rightButtonClicked(point);
}
 
#include "knewmailview.moc"
