#include "knewmail.h"
#include "errordialog.h"
#include <iostream.h>

#include <kapp.h>
#include <kmsgbox.h>
#include <qstring.h>

CErrorDialog *gErrorDialog;

int main(int argc, char *argv[])
{
  int exitStatus = 0;
  int startDocked = 0;
  int noSplash = 0;
  int upgrade = 0;
  QString param;

  KApplication *app = new KApplication(argc,argv,"knewmail");  

  // create the global error dialog
  gErrorDialog = new CErrorDialog;

  /////////////////////////////////////////
  // Parse the command line args
  for (int i = 1; i <= argc; i++)
    {
      param = argv[i];

      if (param == "-dock")
	startDocked = 1;

      else if (param == "-upgrade")
	upgrade = 1;

      else if (param == "-nosplash")
	noSplash = 1;
    }

  if (kapp->isRestored())
    { 
      RESTORE(KNewMailApp);
    }

  else   // Not restored, need to create a new one.
    {
      KNewMailApp* knewmail;
      knewmail = new KNewMailApp(noSplash, upgrade);

      if (!startDocked)
	knewmail->show();
      else
	knewmail->slotDock();
    }

  // create the app and get the error status apon quiting
  exitStatus = app->exec();

  // cleanup
  //delete(gErrorDialog);

  return exitStatus;
}
