// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1998 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <qframe.h>
#include <qlayout.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qlined.h>
#include <qdialog.h>
#include <qcombo.h>
#include <qmsgbox.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qbttngrp.h>

#include <kapp.h>
#include <ktabctl.h>

#include "confdialog.h"
#include "confdialog.moc"
#include "PipeCom.h"
#include "server.h"
#include "watchlist.h"
#include "users.h"
#include "mainlist.h"

extern Server *serv;
extern MainRowTable *watchlist;

//------------------------------------------------
// PasswdDialog
//------------------------------------------------

PasswdDialog::PasswdDialog (QWidget *parent, int mode)
  : QDialog(parent, 0, TRUE)
{
  initMetaObject();
  setCaption(klocale->translate("Type in password"));
  newpasswd = mode;

  if( mode == 2 )
    {
      le_id = new QLineEdit( this, "");
      le_id->setGeometry( 120, 24, 168, 24 );
      le_id->setMinimumSize( 10, 10 );
      le_id->setMaximumSize( 32767, 32767 );
      le_id->setText( "" );
      le_id->setMaxLength( 32767 );
      le_id->setEchoMode( QLineEdit::Normal );
      le_id->setFrame( TRUE );

      QLabel* dlgedit_Label_3;
      dlgedit_Label_3 = new QLabel( this, "Label_2" );
      dlgedit_Label_3->setGeometry( 8, 24, 100, 24 );
      dlgedit_Label_3->setText( klocale->translate("Account Id:") );
      dlgedit_Label_3->setAlignment( 290 );
      dlgedit_Label_3->setMargin( -1 );
    }

  QLabel* dlgedit_Label_1;
  dlgedit_Label_1 = new QLabel( this, "Label_1" );
  dlgedit_Label_1->setGeometry( 8, 24, 100, 24 );
  dlgedit_Label_1->setText( klocale->translate("Password:") );
  dlgedit_Label_1->setAlignment( 290 );
  dlgedit_Label_1->setMargin( -1 );
  
  le_passwd = new QLineEdit( this, "LineEdit_2" );
  le_passwd->setGeometry( 120, 24, 168, 24 );
  le_passwd->setMinimumSize( 10, 10 );
  le_passwd->setMaximumSize( 32767, 32767 );
  le_passwd->setText( "" );
  le_passwd->setMaxLength( 10 );
  le_passwd->setEchoMode( QLineEdit::Password );
  le_passwd->setFrame( TRUE );
  le_passwd->setFocus();

  if( mode == 2 )
    {
      dlgedit_Label_1->move( 8, 64 );
      le_passwd->move( 120, 64 );
      le_id->setFocus();
    }
  if( mode == 1 )
    {
      le_passwd2 = new QLineEdit( this, "LineEdit_1" );
      le_passwd2->setGeometry( 120, 64, 168, 24 );
      le_passwd2->setMinimumSize( 10, 10 );
      le_passwd2->setMaximumSize( 32767, 32767 );
      le_passwd2->setText( "" );
      le_passwd2->setMaxLength( 10 );
      le_passwd2->setEchoMode( QLineEdit::Password );
      le_passwd2->setFrame( TRUE );

      QLabel* dlgedit_Label_2;
      dlgedit_Label_2 = new QLabel( this, "Label_2" );
      dlgedit_Label_2->setGeometry( 8, 64, 100, 24 );
      dlgedit_Label_2->setText( klocale->translate("Retype password:") );
      dlgedit_Label_2->setAlignment( 290 );
      dlgedit_Label_2->setMargin( -1 );
    }

  b_ok = new QPushButton( this, "PushButton_1" );
  b_ok->setGeometry( 48, 112, 100, 24 );
  b_ok->setMinimumSize( 10, 10 );
  b_ok->setMaximumSize( 32767, 32767 );
  b_ok->setText( klocale->translate("Ok") );
  b_ok->setAutoRepeat( FALSE );
  b_ok->setAutoResize( FALSE );
  
  b_cancel = new QPushButton( this, "PushButton_2" );
  b_cancel->setGeometry( 176, 112, 100, 24 );
  b_cancel->setMinimumSize( 10, 10 );
  b_cancel->setMaximumSize( 32767, 32767 );
  b_cancel->setText( klocale->translate("Cancel") );
  b_cancel->setAutoRepeat( FALSE );
  b_cancel->setAutoResize( FALSE );
  
  connect( b_ok, SIGNAL(clicked()), this, SLOT(accept()) );
  connect( b_cancel, SIGNAL(clicked()), this, SLOT(reject()) );
  
  resize( 320,160 );
  setFixedSize( 320, 160 );
}

void PasswdDialog::accept()
{
  if( newpasswd != 1 || ((QString) le_passwd->text()) == ((QString) le_passwd2->text()) )
    QDialog::accept();
  else
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("The passwords don't match!\n
Please try again.") );
      restart();
    }
}

unsigned long PasswdDialog::getId()
{
  QString temp = le_id->text();
  return temp.toULong();
}

void PasswdDialog::restart()
{
  le_passwd->setText( "" );  
  le_passwd->setFocus();
  if( newpasswd == 2 )
    {
      le_id->setText( "" );
      le_id->setFocus();
    }
  else if( newpasswd == 1 )
    {
      le_passwd2->setText( "" );  
      le_passwd->setFocus();
    }
  b_ok->repaint(TRUE);
}

//------------------------------------------------
// RegisterUser Dialog
//------------------------------------------------

RegisterUser::RegisterUser(QWidget *parent, QString pass)
  : QDialog(parent, 0, TRUE)
{
  initMetaObject();
  setCaption(klocale->translate("Register user"));

  passwd = pass;

  b_ok = new QPushButton(klocale->translate("Ok"), this);
  b_ok->setFixedSize(80, 24);
  b_ok->move(230, 220);

  QLabel* dlgedit_Label_3;
  dlgedit_Label_3 = new QLabel( this, "Label_3" );
  dlgedit_Label_3->setGeometry( 16, 32, 96, 24 );
  dlgedit_Label_3->setText( klocale->translate("Name:") );
  dlgedit_Label_3->setAlignment( 290 );
  dlgedit_Label_3->setMargin( -1 );
  
  QLabel* dlgedit_Label_4;
  dlgedit_Label_4 = new QLabel( this, "Label_4" );
  dlgedit_Label_4->setGeometry( 16, 64, 96, 24 );
  dlgedit_Label_4->setText( klocale->translate("First name:") );
  dlgedit_Label_4->setAlignment( 290 );
  dlgedit_Label_4->setMargin( -1 );
  
  QLabel* dlgedit_Label_6;
  dlgedit_Label_6 = new QLabel( this, "Label_6" );
  dlgedit_Label_6->setGeometry( 16, 96, 96, 24 );
  dlgedit_Label_6->setText( klocale->translate("Nickname:") );
  dlgedit_Label_6->setAlignment( 290 );
  dlgedit_Label_6->setMargin( -1 );

  QLabel* dlgedit_Label_7;
  dlgedit_Label_7 = new QLabel( this, "Label_7" );
  dlgedit_Label_7->setGeometry( 16, 128, 96, 24 );
  dlgedit_Label_7->setText( klocale->translate("Email:") );
  dlgedit_Label_7->setAlignment( 290 );
  dlgedit_Label_7->setMargin( -1 );

  QLabel* dlgedit_Label_5;
  dlgedit_Label_5 = new QLabel( this, "Label_5" );
  dlgedit_Label_5->setGeometry( 16, 160, 96, 24 );
  dlgedit_Label_5->setText( klocale->translate("Account ID:") );
  dlgedit_Label_5->setAlignment( 290 );
  dlgedit_Label_5->setMargin( -1 );
  
  le_name = new QLineEdit( this, "LineEdit_3" );
  le_name->setGeometry( 120, 32, 208, 24 );
  le_name->setMinimumSize( 10, 10 );
  le_name->setMaximumSize( 32767, 32767 );
  le_name->setText( "" );
  le_name->setMaxLength( 80 );
  le_name->setEchoMode( QLineEdit::Normal );
  le_name->setFrame( TRUE );
  
  le_fname = new QLineEdit( this, "LineEdit_4" );
  le_fname->setGeometry( 120, 64, 208, 24 );
  le_fname->setMinimumSize( 10, 10 );
  le_fname->setMaximumSize( 32767, 32767 );
  le_fname->setText( "" );
  le_fname->setMaxLength( 80 );
  le_fname->setEchoMode( QLineEdit::Normal );
  le_fname->setFrame( TRUE );
  
  le_nname = new QLineEdit( this, "LineEdit_5" );
  le_nname->setGeometry( 120, 96, 208, 24 );
  le_nname->setMinimumSize( 10, 10 );
  le_nname->setMaximumSize( 32767, 32767 );
  le_nname->setText( "" );
  le_nname->setMaxLength( 40 );
  le_nname->setEchoMode( QLineEdit::Normal );
  le_nname->setFrame( TRUE );
  
  le_email = new QLineEdit( this, "LineEdit_6" );
  le_email->setGeometry( 120, 128, 208, 24 );
  le_email->setMinimumSize( 10, 10 );
  le_email->setMaximumSize( 32767, 32767 );
  le_email->setText( "" );
  le_email->setMaxLength( 80 );
  le_email->setEchoMode( QLineEdit::Normal );
  le_email->setFrame( TRUE );

  le_id = new QLineEdit( this, "LineEdit_7" );
  le_id->setGeometry( 120, 160, 88, 24 );
  le_id->setMinimumSize( 10, 10 );
  le_id->setMaximumSize( 32767, 32767 );
  le_id->setText( "" );
  le_id->setMaxLength( 32767 );
  le_id->setEchoMode( QLineEdit::Normal );
  le_id->setFrame( TRUE );
  le_id->setEnabled( FALSE );

  le_name->setFocus();

  b_create = new QPushButton( this, "PushButton_1" );
  b_create->setGeometry( 352, 32, 136, 24 );
  b_create->setMinimumSize( 10, 10 );
  b_create->setMaximumSize( 32767, 32767 );
  b_create->setText( klocale->translate("Create account") );
  b_create->setAutoRepeat( FALSE );
  b_create->setAutoResize( FALSE );

  b_change = new QPushButton( this, "PushButton_1" );
  b_change->setGeometry( 352, 64, 136, 24 );
  b_change->setMinimumSize( 10, 10 );
  b_change->setMaximumSize( 32767, 32767 );
  b_change->setText( klocale->translate("Change account") );
  b_change->setAutoRepeat( FALSE );
  b_change->setAutoResize( FALSE );

  b_remove = new QPushButton( this, "PushButton_1" );
  b_remove->setGeometry( 352, 96, 136, 24 );
  b_remove->setMinimumSize( 10, 10 );
  b_remove->setMaximumSize( 32767, 32767 );
  b_remove->setText( klocale->translate("Remove account") );
  b_remove->setAutoRepeat( FALSE );
  b_remove->setAutoResize( FALSE );

  b_account = new QPushButton( this, "PushButton_1" );
  b_account->setGeometry( 320, 160, 168, 24 );
  b_account->setMinimumSize( 10, 10 );
  b_account->setMaximumSize( 32767, 32767 );
  b_account->setText( klocale->translate("Choose another account") );
  b_account->setAutoRepeat( FALSE );
  b_account->setAutoResize( FALSE );

  connect( b_create, SIGNAL(clicked()), this, SLOT(createAccount()) );
  connect( b_change, SIGNAL(clicked()), this, SLOT(changeAccount()) );
  connect( b_remove, SIGNAL(clicked()), this, SLOT(removeAccount()) );
  connect( b_account, SIGNAL(clicked()), this, SLOT(chooseAccount()) );

  connect( b_ok, SIGNAL(clicked()), this, SLOT(accept()) );

  readConfig();

  b_remove->setEnabled(FALSE);
  b_change->setEnabled(FALSE);

  setMinimumSize(550, 260);
  resize(550, 260);
}

int RegisterUser::exec()
{
  // getInfo from server 
  int rcode;
  struct users rec;
  unsigned long my_id = ((QString) le_id->text()).toULong();

  // make sure server object is initialized
  if( serv->init(ip, port, (const char *) passwd, my_id) )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("I can't find the server.\n
Please check the name or use the IP number.") );
      return 0;
    }
  if( my_id != 0 )
    {
      PasswdDialog dialog(0, 0);
      while( (rcode = serv->getInfo( my_id, (const char *) passwd, &rec )) != RE_OK)
	{
	  if( rcode != RE_PASSWD )
	    {
	      if( rcode == RE_ACCESS_DENIED )
		{
		  QMessageBox::critical( 0, klocale->translate("Konline"),
					 klocale->translate("The server has denied your access."));
		  return 0;
		}
	      else
		{
		  QMessageBox::critical( 0, klocale->translate("Konline"),
					 klocale->translate("I can't connect to the server.\n
Please check IP and PORT settings.") );
		  return 0;
		}
	    }
	  else
	    {
	      KConfig *config = KApplication::getKApplication()->getConfig();
	      config->setGroup("konline");
	      if( config->readBoolEntry("SavePasswd", FALSE) )
		QMessageBox::critical( 0, klocale->translate("Konline"),
				       klocale->translate("The given password is wrong.") );
	      dialog.restart();
	      if( dialog.exec() )
		{
		  passwd = dialog.getPasswd();
		  serv->setAccount( (const char *) passwd, my_id );
		}
	      else
		return QDialog::exec();
	    }
	}
      le_name->setText(rec.name);
      le_fname->setText(rec.fname);
      le_nname->setText(rec.nname);
      le_email->setText(rec.email);	  
      b_remove->setEnabled(TRUE);
      b_change->setEnabled(TRUE);
    }
  return QDialog::exec();
}

void RegisterUser::readConfig()
{
  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup("konline");
  QString temp;
  ip = config->readEntry("Server", "");
  temp = config->readEntry("Port", "");
  port = temp.toUShort();
  le_id->setText(config->readEntry("AId","0"));
}

void RegisterUser::writeConfig()
{
  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup("konline");
  config->writeEntry("AId", le_id->text());
  if( config->readBoolEntry("SavePasswd", FALSE ) )
    config->writeEntry("Passwd", passwd);
  else
    config->writeEntry("Passwd", "");
}

void RegisterUser::createAccount()
{
  int rcode;
  unsigned long id = 0;

  PasswdDialog dialog(this, 1);
  if( dialog.exec() )
    {
      passwd = dialog.getPasswd();
      rcode = serv->create( le_name->text(),
			    le_fname->text(),
			    le_nname->text(),
			    le_email->text(),
			    (const char *) passwd,
			    &id);
      if( rcode == RE_COM )
	{
	  QMessageBox::critical( 0, klocale->translate("Konline"),
				 klocale->translate("I can't connect to the server.\n
Please check IP and PORT settings.") );
	  return;
	}
      if( rcode == RE_ACCESS_DENIED )
	{
	  QMessageBox::critical( 0, klocale->translate("Konline"),
				 klocale->translate("The server has denied your access.") );
	  return;
	}
      if( rcode )
	{
	  QMessageBox::critical( 0, klocale->translate("Konline"),
				 klocale->translate("I can't create a new account for you.\n
Please note that every account needs a unique email address.") );
	}
      else
	{
	  QString temp;
	  temp.setNum(id);
	  le_id->setText(temp);
	  b_remove->setEnabled(TRUE);
	  b_change->setEnabled(TRUE);
	}
    }
}  

void RegisterUser::changeAccount()
{
  int rcode;
  PasswdDialog dialog(this, 1);
  if( dialog.exec() )
    {
      QString new_passwd = dialog.getPasswd();

      rcode = serv->change( le_name->text(),
			    le_fname->text(),
			    le_nname->text(),
			    le_email->text(),
			    (const char *) new_passwd );
      if( rcode == RE_OK )
	{
	  passwd = new_passwd;
	}
      if( rcode == RE_COM )
	{
	  QMessageBox::critical( 0, klocale->translate("Konline"),
				 klocale->translate("I can't connect to the server.\n
Please check IP and PORT settings.") );
	  return;
	}
      if( rcode == RE_ACCESS_DENIED )
	{
	  QMessageBox::critical( 0, klocale->translate("Konline"),
				 klocale->translate("The server has denied your access.") );
	  return;
	}
      if( rcode )
	{
	  QMessageBox::critical( 0, klocale->translate("Konline"),
				 klocale->translate("I can't change your account settings.\n
Please note that every account needs a unique email address.") );
	}
    }
}

void RegisterUser::removeAccount()
{
  if( QMessageBox::warning(0, klocale->translate("Delete account"),
			   klocale->translate("Are you sure you want to delete
your account from the server ?"),
			   klocale->translate("Ok"),
			   klocale->translate("Cancel"), 0, 0, 1) != 0 )
    {
      return;
    }
  
  int rcode;
  rcode = serv->remove();
  if( rcode == RE_COM )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("I can't connect to the server.\n
Please check IP and PORT settings.") );
      return;
    }
  if( rcode == RE_ACCESS_DENIED )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("The server has denied your access.") );
      return;
    }
  if( rcode )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("I can't remove your account from the server.") );
    }
  else
    {
      b_remove->setEnabled(FALSE);
      b_change->setEnabled(FALSE);
    }
}

void RegisterUser::chooseAccount()
{
  PasswdDialog dialog(this, 2);
  //unsigned long my_id = ((QString) le_id->text()).toULong();
  struct users rec;
  int rcode;
  QString temp;
  if( dialog.exec() )
    {
      //serv->setAccount( (const char *) dialog.getPasswd(), my_id);
      rcode = serv->getInfo( dialog.getId(), (const char *) dialog.getPasswd(), &rec );
      if( rcode == RE_COM )
	{
	  QMessageBox::critical( 0, klocale->translate("Konline"),
				 klocale->translate("I can't connect to the server.\n
Please check IP and PORT settings.") );
	  return;
	}
      if( rcode == RE_PASSWD )
	{
	  QMessageBox::warning( 0, klocale->translate("Konline"),
				klocale->translate("The password for the given account is wrong."
						   ));
	}
      else
	{
	  passwd = dialog.getPasswd();
	  le_name->setText(rec.name);
	  le_fname->setText(rec.fname);
	  le_nname->setText(rec.nname);
	  le_email->setText(rec.email);	  
	  temp.setNum(dialog.getId());
	  le_id->setText(temp);
	  b_remove->setEnabled(TRUE);
	  b_change->setEnabled(TRUE);
	  serv->setAccount( (const char *) dialog.getPasswd(), dialog.getId() );
	}
    }      
}
  
//------------------------------------------------
// AddWatchList Dialog
//------------------------------------------------

AddWatchList::AddWatchList(QWidget *parent)
  : QDialog(parent, 0, TRUE)
{
  initMetaObject();
  setCaption(klocale->translate("Add user to watchlist"));

  b_ok = new QPushButton(klocale->translate("Ok"), this);
  b_ok->setFixedSize(80, 34);
  b_ok->setDefault(TRUE);

  QFrame *f_w_list = new QFrame(this);
  QFrame *f_w_main = new QFrame(this);
  f_w_main->setMinimumSize(432, 180);

  QGridLayout *l_w_top_down = new QGridLayout(this, 3, 1, 4);
  l_w_top_down->addWidget(f_w_main, 0, 0);
  l_w_top_down->addWidget(f_w_list, 1, 0);
  l_w_top_down->setRowStretch(1, 1);
  l_w_top_down->addRowSpacing( 2, 40 );
  l_w_top_down->addWidget(b_ok, 2, 0, AlignCenter);
  l_w_top_down->activate();

  lb_w_list = new MyRowTable( f_w_list, "ListBox_1" );
  lb_w_list->setMinimumSize( 504, 60 );
  lb_w_list->setFrameStyle( 51 );
  lb_w_list->setLineWidth( 2 );
  lb_w_list->setAutoDelete(TRUE);

  h_w_list = new KHeader( f_w_list, "Header_1", 6, KHeader::Resizable | KHeader::Buttons );
  h_w_list->setMinimumSize( 504, 20 );
  h_w_list->setHeaderLabel( 0, klocale->translate("A"), AlignLeft | AlignVCenter );
  h_w_list->setHeaderLabel( 1, klocale->translate("Name"), AlignLeft | AlignVCenter );
  h_w_list->setHeaderLabel( 2, klocale->translate("First name"), AlignLeft | AlignVCenter );
  h_w_list->setHeaderLabel( 3, klocale->translate("Nickname"), AlignLeft | AlignVCenter );
  h_w_list->setHeaderLabel( 4, klocale->translate("Email"), AlignLeft | AlignVCenter );
  h_w_list->setHeaderLabel( 5, klocale->translate("ID"), AlignLeft | AlignVCenter );

  connect( h_w_list, SIGNAL(sizeChanged(int,int)),
           lb_w_list, SLOT(setColumnWidth(int,int)) );
  // This connection makes it jumpy and slow (but it works!)
  //      connect( h_w_list, SIGNAL(sizeChanging(int,int)),
  //                       lb_w_list, SLOT(setColumnWidth(int,int)) );
  connect( lb_w_list, SIGNAL(hSliderMoved(int)),
           h_w_list, SLOT(setOrigin(int)) );
  //connect( lb_w_list, SIGNAL(rightButtonClicked()), this, SLOT(popupMenu()) );
  connect( lb_w_list, SIGNAL(selected(int,int)), this, SLOT(doubleClick(int,int)) );

  h_w_list->setHeaderSize( 0, 24 );
  h_w_list->setHeaderSize( 1, 110 );
  h_w_list->setHeaderSize( 2, 110 );
  h_w_list->setHeaderSize( 3, 80 );
  h_w_list->setHeaderSize( 4, 150 );
  h_w_list->setHeaderSize( 5, 40 );

  QGridLayout *l_w_list = new QGridLayout( f_w_list, 2, 1, 4 );
  l_w_list->addWidget( h_w_list, 0, 0, AlignCenter );
  l_w_list->addWidget( lb_w_list, 1, 0, AlignCenter );
  l_w_list->setRowStretch( 1, 1 );
  l_w_list->activate();

  QLabel* dlgedit_Label;
  dlgedit_Label = new QLabel( f_w_main, "Label_3" );
  dlgedit_Label->setGeometry( 216, 40, 100, 24 );
  dlgedit_Label->setText( "First name:" );
  dlgedit_Label->setAlignment( 289 );
  dlgedit_Label->setMargin( -1 );

  c_w_key = new QComboBox( FALSE, f_w_main, "ComboBox_1" );
  c_w_key->setGeometry( 120, 16, 120, 24 );
  c_w_key->setMinimumSize( 10, 10 );
  c_w_key->setMaximumSize( 32767, 32767 );
  c_w_key->setSizeLimit( 10 );
  c_w_key->setAutoResize( FALSE );
  c_w_key->insertItem( "Name" );
  c_w_key->insertItem( "Nickname" );
  c_w_key->insertItem( "Email" );
  c_w_key->insertItem( "ID" );
  
  le_w_name = new QLineEdit( f_w_main, "LineEdit_1" );
  le_w_name->setGeometry( 24, 64, 184, 24 );
  le_w_name->setMinimumSize( 10, 10 );
  le_w_name->setMaximumSize( 32767, 32767 );
  le_w_name->setText( "" );
  le_w_name->setMaxLength( 32767 );
  le_w_name->setEchoMode( QLineEdit::Normal );
  le_w_name->setFrame( TRUE );
  
  le_w_fname = new QLineEdit( f_w_main, "LineEdit_2" );
  le_w_fname->setGeometry( 224, 64, 184, 24 );
  le_w_fname->setMinimumSize( 10, 10 );
  le_w_fname->setMaximumSize( 32767, 32767 );
  le_w_fname->setText( "" );
  le_w_fname->setMaxLength( 32767 );
  le_w_fname->setEchoMode( QLineEdit::Normal );
  le_w_fname->setFrame( TRUE );
  
  le_w_nname = new QLineEdit( f_w_main, "LineEdit_3" );
  le_w_nname->setGeometry( 24, 112, 184, 24 );
  le_w_nname->setMinimumSize( 10, 10 );
  le_w_nname->setMaximumSize( 32767, 32767 );
  le_w_nname->setText( "" );
  le_w_nname->setMaxLength( 32767 );
  le_w_nname->setEchoMode( QLineEdit::Normal );
  le_w_nname->setFrame( TRUE );
  
  le_w_email = new QLineEdit( f_w_main, "LineEdit_4" );
  le_w_email->setGeometry( 224, 112, 184, 24 );
  le_w_email->setMinimumSize( 10, 10 );
  le_w_email->setMaximumSize( 32767, 32767 );
  le_w_email->setText( "" );
  le_w_email->setMaxLength( 32767 );
  le_w_email->setEchoMode( QLineEdit::Normal );
  le_w_email->setFrame( TRUE );
  
  le_w_id = new QLineEdit( f_w_main, "LineEdit_5" );
  le_w_id->setGeometry( 312, 16, 96, 24 );
  le_w_id->setMinimumSize( 10, 10 );
  le_w_id->setMaximumSize( 32767, 32767 );
  le_w_id->setText( "" );
  le_w_id->setMaxLength( 32767 );
  le_w_id->setEchoMode( QLineEdit::Normal );
  le_w_id->setFrame( TRUE );
  
  dlgedit_Label = new QLabel( f_w_main, "Label_1" );
  dlgedit_Label->setGeometry( 16, 16, 96, 24 );
  dlgedit_Label->setText( "Primary key:" );
  dlgedit_Label->setAlignment( 290 );
  dlgedit_Label->setMargin( -1 );
  
  dlgedit_Label = new QLabel( f_w_main, "Label_2" );
  dlgedit_Label->setGeometry( 16, 40, 100, 24 );
  dlgedit_Label->setText( "Name:" );
  dlgedit_Label->setAlignment( 289 );
  dlgedit_Label->setMargin( -1 );
  
  dlgedit_Label = new QLabel( f_w_main, "Label_10" );
  dlgedit_Label->setGeometry( 16, 88, 100, 24 );
  dlgedit_Label->setText( "Nickname:" );
  dlgedit_Label->setAlignment( 289 );
  dlgedit_Label->setMargin( -1 );
  
  dlgedit_Label = new QLabel( f_w_main, "Label_11" );
  dlgedit_Label->setGeometry( 216, 88, 100, 24 );
  dlgedit_Label->setText( "Email:" );
  dlgedit_Label->setAlignment( 289 );
  dlgedit_Label->setMargin( -1 );
  
  dlgedit_Label = new QLabel( f_w_main, "Label_12" );
  dlgedit_Label->setGeometry( 264, 16, 40, 24 );
  dlgedit_Label->setText( "ID:" );
  dlgedit_Label->setAlignment( 290 );
  dlgedit_Label->setMargin( -1 );
  
  b_w_add = new QPushButton( f_w_main, "PushButton_2" );
  b_w_add->setGeometry( 264, 152, 144, 24 );
  b_w_add->setMinimumSize( 10, 10 );
  b_w_add->setMaximumSize( 32767, 32767 );
  b_w_add->setText( "Add to watchlist" );
  b_w_add->setAutoRepeat( FALSE );
  b_w_add->setAutoResize( FALSE );
  
  b_w_search = new QPushButton( f_w_main, "PushButton_3" );
  b_w_search->setGeometry( 16, 152, 144, 24 );
  b_w_search->setMinimumSize( 10, 10 );
  b_w_search->setMaximumSize( 32767, 32767 );
  b_w_search->setText( "Submit search" );
  b_w_search->setAutoRepeat( FALSE );
  b_w_search->setAutoResize( FALSE );

  connect( b_w_search, SIGNAL(clicked()), this, SLOT(subSearch()) );  
  connect( b_w_add, SIGNAL(clicked()), this, SLOT(addWatchList()) );  

  connect( b_ok, SIGNAL(clicked()), this, SLOT(accept()) );

  readConfig();

  setMinimumSize(534, 400);
  resize(534, 400);
}

void AddWatchList::readConfig()
{
  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup("konline");
  ip = config->readEntry("Server");
  QString temp = config->readEntry("Port");
  port = temp.toUShort();
  temp = config->readEntry("AId","0");
  my_id = temp.toULong();
  passwd = config->readEntry("Passwd","");
}

void AddWatchList::subSearch()
{
  int rcode;
  struct users rec;
  User drec;
  short key = 0;;
  unsigned long id = ((QString) le_w_id->text()).toULong();
  /*
  if( serv->init(ip, port, 0, my_id) )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("I can't find the server.\n
Please check the name or use the IP number.") );
      return;
    }
    */
  lb_w_list->setUpdatesEnabled(FALSE);
  lb_w_list->clear();
  switch(c_w_key->currentItem()) {
  case 0:
    key = SE_NAME;
    break;
  case 1:
    key = SE_NNAME;
    break;
  case 2:
    key = SE_EMAIL;
    break;
  case 3:
    key = SE_ID;
    break;
  };
  rcode = serv->findUser( key,
			  le_w_name->text(),
			  le_w_fname->text(),
			  le_w_nname->text(),
			  le_w_email->text(),
			  id,
			  &rec);
  if(rcode == RE_OK)
    {
      do {
	drec.name = rec.name;
	drec.fname = rec.fname;
	drec.nname = rec.nname;
	drec.email = rec.email;
	drec.id = rec.user_id;
	lb_w_list->insertItem( &drec, watchlist->contains(drec.id) );
      } while( serv->findNext(&rec) == RE_OK );
    }
  lb_w_list->setUpdatesEnabled(TRUE);
  if( lb_w_list->count() )
    lb_w_list->setCurrentItem( 0 );
  lb_w_list->repaint(FALSE);
}

void AddWatchList::addWatchList()
{
  if( !lb_w_list->count() )
    return;
  /*
  if( serv->init(ip, port, (const char *) passwd, my_id) )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("I can't find the server.\n
Please check the name or use the IP number.") );
      return;
    }
    */
  short rcode;
  unsigned long new_id = lb_w_list->accId(lb_w_list->currentItem());
  rcode = serv->addWatchList( new_id );
  if( rcode == RE_COM )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("I can't connect to the server.\n
Please check IP and PORT settings.") );
      return;
    }
  if( rcode == RE_ACCESS_DENIED )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("The server has denied your access.") );
      return;
    }
  if( rcode != RE_OK )
    {
      QMessageBox::critical( 0, klocale->translate("Konline"),
			     klocale->translate("I can't add this user to your watchlist.") );
      return;
    }
  lb_w_list->setActive( lb_w_list->currentItem(), TRUE );
  lb_w_list->repaint(FALSE);
}

//------------------------------------------------
// ConfDialog
//------------------------------------------------

ConfDialog::ConfDialog (QWidget *parent )
  : QDialog(parent, 0, TRUE)
{
  initMetaObject();
  setCaption(klocale->translate("Configure KOnline"));

  tabbar = new KTabCtl(this);
  tabbar->setGeometry(10, 10, 300, 300);
  QFrame *f_account = new QFrame(tabbar);
  tabbar->addTab(f_account, klocale->translate("Server"));
  QFrame *f_secure = new QFrame(tabbar);
  tabbar->addTab(f_secure, klocale->translate("Security"));

  b_ok = new QPushButton(klocale->translate("Ok"), this);
  b_ok->setFixedSize(80, 24);
  b_cancel = new QPushButton(klocale->translate("Cancel"), this);
  b_cancel->setFixedSize(80, 24);
  
  QGridLayout *l_top_down = new QGridLayout(this, 2, 1, 4);
  QBoxLayout *l_buttons = new QBoxLayout(QBoxLayout::LeftToRight);
  l_top_down->addWidget(tabbar, 0, 0);
  l_top_down->setRowStretch(0, 1);
  l_top_down->setColStretch(0, 1);
  l_top_down->addLayout(l_buttons, 1, 0);
  l_buttons->addStretch(1);
  l_buttons->addWidget(b_ok);
  l_buttons->addStretch(1);
  l_buttons->addWidget(b_cancel);
  l_buttons->addStretch(1);
  l_top_down->activate();

  // --------------------------------------------------
  // generate server dialog --------------------------

  QLabel* dlgedit_Label_1;
  dlgedit_Label_1 = new QLabel( f_account, "Label_1" );
  dlgedit_Label_1->setGeometry( 16, 16, 100, 24 );
  dlgedit_Label_1->setMinimumSize( 10, 10 );
  dlgedit_Label_1->setMaximumSize( 32767, 32767 );
  dlgedit_Label_1->setText( "Server IP:" );
  dlgedit_Label_1->setAlignment( 289 );
  dlgedit_Label_1->setMargin( -1 );

  QLabel* dlgedit_Label_2;
  dlgedit_Label_2 = new QLabel( f_account, "Label_2" );
  dlgedit_Label_2->setGeometry( 256, 16, 100, 24 );
  dlgedit_Label_2->setMinimumSize( 10, 10 );
  dlgedit_Label_2->setMaximumSize( 32767, 32767 );
  dlgedit_Label_2->setText( "Server port:" );
  dlgedit_Label_2->setAlignment( 289 );
  dlgedit_Label_2->setMargin( -1 );
  
  le_ip = new QLineEdit( f_account, "LineEdit_2" );
  le_ip->setGeometry( 24, 40, 216, 24 );
  le_ip->setMinimumSize( 10, 10 );
  le_ip->setMaximumSize( 32767, 32767 );
  le_ip->setText( "" );
  le_ip->setMaxLength( 120 );
  le_ip->setEchoMode( QLineEdit::Normal );
  le_ip->setFrame( TRUE );

  le_port = new QLineEdit( f_account, "LineEdit_1" );
  le_port->setGeometry( 264, 40, 80, 24 );
  le_port->setMinimumSize( 10, 10 );
  le_port->setMaximumSize( 32767, 32767 );
  le_port->setText( "" );
  le_port->setMaxLength( 32767 );
  le_port->setEchoMode( QLineEdit::Normal );
  le_port->setFrame( TRUE );
  
  le_ip->setFocus();

  // --------------------------------------------------
  // generate security dialog -------------------------

  /*
  bb_ip = new QButtonGroup( f_secure, "ButtonGroup_1" );
  bb_ip->setGeometry( 24, 64, 232, 128 );
  bb_ip->setMinimumSize( 10, 10 );
  bb_ip->setMaximumSize( 32767, 32767 );
  bb_ip->setFrameStyle( 49 );
  bb_ip->setTitle( "Give IP-Address" );
  bb_ip->setAlignment( 1 );
  bb_ip->setExclusive( TRUE );
  */  

  cb_passwd = new QCheckBox( f_secure, "CheckBox_1" );
  cb_passwd->setGeometry( 24, 24, 128, 24 );
  cb_passwd->setMinimumSize( 10, 10 );
  cb_passwd->setMaximumSize( 32767, 32767 );
  cb_passwd->setText( "Save password" );
  cb_passwd->setAutoRepeat( FALSE );
  cb_passwd->setAutoResize( TRUE );

  /*  
  rb_never = new QRadioButton( f_secure, "RadioButton_1" );
  rb_never->setGeometry( 48, 88, 192, 24 );
  rb_never->setMinimumSize( 10, 10 );
  rb_never->setMaximumSize( 32767, 32767 );
  rb_never->setText( "Never" );
  rb_never->setAutoRepeat( FALSE );
  rb_never->setAutoResize( FALSE );
  rb_never->setChecked( TRUE );
  
  rb_ask = new QRadioButton( f_secure, "RadioButton_2" );
  rb_ask->setGeometry( 48, 120, 192, 24 );
  rb_ask->setMinimumSize( 10, 10 );
  rb_ask->setMaximumSize( 32767, 32767 );
  rb_ask->setText( "Ask" );
  rb_ask->setAutoRepeat( FALSE );
  rb_ask->setAutoResize( FALSE );
  
  rb_always = new QRadioButton( f_secure, "RadioButton_3" );
  rb_always->setGeometry( 48, 152, 192, 24 );
  rb_always->setMinimumSize( 10, 10 );
  rb_always->setMaximumSize( 32767, 32767 );
  rb_always->setText( "Always" );
  rb_always->setAutoRepeat( FALSE );
  rb_always->setAutoResize( FALSE );

  bb_ip->insert( rb_never );
  bb_ip->insert( rb_ask );
  bb_ip->insert( rb_always );
  */

  readConfig();
  
  connect( b_ok, SIGNAL(clicked()), this, SLOT(accept()) );
  connect( b_cancel, SIGNAL(clicked()), this, SLOT(reject()) );

  setMinimumSize(400, 300);
  resize(400, 300);
}

void ConfDialog::readConfig()
{
  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup("konline");
  le_ip->setText(config->readEntry("Server"));
  le_port->setText(config->readEntry("Port"));
  cb_passwd->setChecked(config->readBoolEntry("SavePasswd", FALSE));
}

void ConfDialog::writeConfig()
{
  KConfig *config = KApplication::getKApplication()->getConfig();
  config->setGroup("konline");
  config->writeEntry("Server", le_ip->text());
  config->writeEntry("Port", le_port->text());
  config->writeEntry("SavePasswd", cb_passwd->isChecked());
}



