// -*- C++ -*-

//
//  konline
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef mainlist_included
#define mainlist_included

#include "kheader.h"
#include "krowtable.h"

class User;
class Konline;

class MainRow : public KRow
{
  friend Konline;
public:
  MainRow(User *row, bool a);
  virtual ~MainRow() {}

  unsigned long accId() { return id; }
  void setActive(bool a) { active = a; }

protected:
  void paint( QPainter *painter, int col, int width );

  bool          active;
  QString       name;
  QString       fname;
  QString       nname;
  QString       email;
  unsigned long id;
};

class MainRowTable : public KRowTable
{
  Q_OBJECT
public:
  MainRowTable( QWidget *parent = 0, const char *name = 0 );
  ~MainRowTable() {}

  void insertItem( User *row, bool active );
  void insertItem( MainRow *row );
  void clear();
  int  currentItem() { return currentRow(); }
  void setCurrentItem(int row);
  unsigned long accId(int row);
  void setActive(int row, bool active) { ((MainRow *) getRow(row))->setActive(active); 
                                         repaint(FALSE); }
  void setActive(unsigned long id, bool active);
  int  count() { return numRows(); }
  bool contains( unsigned long id );

protected:
  int current;
};


#endif /* mainlist_included */
