// -*- C++ -*-

/***************************************************

  definition of: class PipeCom

  class for interprocess communication with pipes.

  used in: LRDM and parser-process

  *************************************************/

#ifndef lrds_pipecom_DEFINED
#define lrds_pipecom_DEFINED

#ifdef __GNUG__
#pragma interface
#endif

extern "C" {
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
}

//#include <string.h>
#include "mystring.h"
#include <iostream.h>

#include "global.h"

class PipeCom {
public:
  PipeCom (int fd_in /*, int fd_out, LrdsError *err*/ ) ;

  ~PipeCom () {}

  PipeCom &operator<<(char c);
  PipeCom &operator>>(char &c);
  PipeCom &operator<<(unsigned char c);
  PipeCom &operator>>(unsigned char &c);

  inline PipeCom &operator<<(short s);
  inline PipeCom &operator>>(short &s);
  PipeCom &operator<<(unsigned short s) { return (*this) << (short) s; }
  PipeCom &operator>>(const unsigned short &s) { return (*this) >> (short &) s; }

  inline PipeCom &operator<<(long l);
  inline PipeCom &operator>>(long &l);
  PipeCom &operator<<(unsigned long l) { return (*this) << (long) l; }
  PipeCom &operator>>(const unsigned long &l) { return (*this) >> (long &) l; }

  PipeCom &operator<<(void *p);
  PipeCom &operator>>(const void *&p);
  PipeCom &operator<<(MyString st);
  PipeCom &operator>>(MyString &st);
  //PipeCom &operator<<(Tid id);
  //PipeCom &operator>>(Tid &id);

  int send();
  int recv();
  void reset_ipos() { ipos = sizeof(short); }

private:
  int setBlocking( int fd, short set );
  int        input;       // input fd
  int        output;      // output fd
  char       ibuf[1024];  // buffer for incomming data
  char       obuf[1024];  // buffer for outgoing data
  short      ipos;        // points one behind the last char in ibuf
  short      opos;        // points one behind the last char in obuf
  //LrdsError *l_error;     // pointer to error object to report errors to
};

inline PipeCom &PipeCom::operator<<(char c)
{
  obuf[opos] = c;
  opos++; 
  return *this; 
}

inline PipeCom &PipeCom::operator>>(char &c)
{
  c = ibuf[ipos];
  ipos++;
  return *this;
}

inline PipeCom &PipeCom::operator<<(unsigned char c)
{
  *((unsigned char*) obuf+opos) = c;
  opos++; 
  return *this; 
}

inline PipeCom &PipeCom::operator>>(unsigned char &c)
{
  c = *((unsigned char*) ibuf+ipos);
  ipos++;
  return *this;
}
// -----SHORT-----
inline PipeCom &PipeCom::operator<<(short s)
{
  s = htons(s);
  obuf[opos] = *((char *) &s);
  opos++;
  obuf[opos] = *(((char *) &s)+1);
  opos++;
  return *this;
}

inline PipeCom &PipeCom::operator>>(short &s)
{
  *((char *) &s) = ibuf[ipos];
  ipos++;
  *(((char *) &s)+1) = ibuf[ipos];
  ipos++;
  s = ntohs(s);
  return *this;
}
// -----LONG-----
inline PipeCom &PipeCom::operator<<(long l)
{
  l = htonl(l);
  for(int i=0; i < sizeof(long); i++)
    {
      obuf[opos] = *((char *) &l+i);
      opos++;
    }
  return *this;
}

inline PipeCom &PipeCom::operator>>(long &l)
{
  for(int i=0; i < sizeof(long); i++)
    {
      *((char *) &l+i) = ibuf[ipos];
      ipos++;
    }
  l = ntohl(l);
  return *this;
}
// -----VOID *------
inline PipeCom &PipeCom::operator<<(void *p)
{
  for(int i=0; i < sizeof(void *); i++)
    {
      obuf[opos] = *((char *) &p+i);
      opos++;
    }
  return *this;
}

inline PipeCom &PipeCom::operator>>(const void *&p)
{
  for(int i=0; i < sizeof(void *); i++)
    {
      *((char *) &p+i) = ibuf[ipos];
      ipos++;
    }
  return *this;
}
// -----MyString-----
inline PipeCom &PipeCom::operator<<(MyString st)
{
  const short len = st.length();
  *this << len;
  for(int i=0; i < len; i++)
    {
      obuf[opos] = st[i];
      opos++;
    }
  return *this;
}

inline PipeCom &PipeCom::operator>>(MyString &st)
{
  short len;
  *this >> len;
  //st = replicate(' ', len);
  st = MyString(len, ' ');
  for(int i=0; i < len; i++)
    {
      st[i] = ibuf[ipos];
      ipos++;
    }
  return *this;
}
// ----- Tid -----
/*
inline PipeCom &PipeCom::operator<<(Tid id)
{
  *this << id.get_page() << id.get_offset();
  return *this;
}

inline PipeCom &PipeCom::operator>>(Tid &id)
{
  unsigned long nr;
  unsigned char p;
  *this >> nr >> p;
  id.init(nr, p);
  return *this;
}
*/
#endif /* lrds_pipecom_DEFINED */


