/*
  kpgp.cpp

  Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */


#include <kcontrol.h>


#include "key.h"
#include "pgpconfig.h"
#include "keyring.h"


class KPGPApplication : public KControlApplication
{
  
public:

  KPGPApplication(int &argc, char **arg, const char *name);

  void apply();

private:

  KPGPConfig    *config;
  KPGPKeyring   *keyring;
};


KPGPApplication::KPGPApplication(int &argc, char **argv, const char *name)
  : KControlApplication(argc, argv, name)
{
  keyring = 0; 
  config  = 0;

  if (runGUI())
    {      
      if (!pages || pages->contains("config"))
	addPage(config = new KPGPConfig(dialog, "config"), "&PGPConfig", "PGPConfig.html");
      
      if (!pages || pages->contains("keyring"))
	addPage(keyring = new KPGPKeyring(dialog, "keyring"), "&Keyring", "PGPKeyring.html");
 
      
      dialog->show();
    } 
}

void KPGPApplication::apply()
{
  if (config)
    config->applySettings();

  if (keyring)
    keyring->applySettings();  
}


int main(int argc, char **argv)
{
  KPGPApplication app(argc, argv, "kpgp");
  
  
  if (app.runGUI())
    return app.exec();
  else
    return 0;
  
  
  return 0;
}