/**********************************************************************

	--- Qt Architect generated file ---

	File: LogViewer.cpp
	Last generated: Sat May 22 13:45:25 1999

 *********************************************************************/

#include <kprocess.h>
#include "LogViewer.h"

#define Inherited LogViewerData

LogViewer::LogViewer
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Log Viewer" );
}


LogViewer::~LogViewer()
{
}

void LogViewer::slotGotData(KProcess *,char *data,int len)
{
	if (len<0)
		return;
	static QString remainder;

	//According to the KProcess docs, we need to copy the data
	//and it seems like data is not always null terminated!
	//This probably leaks memory, and is not elegant. Someone should
	//look at it ;-)
	QString my_data;
	char dst[len+1];
	qstrncpy(dst,data,len+1);
	my_data.setStr(dst);

	//Most of the time, the data comes lines at a time.
	//However, if data is written very quickly, it won't.
	//So, let's split it.

	my_data=remainder+my_data;
	QStrList lines = new QStrList;
	int index=0;
	int newindex=0;
	while (1)
	{
		newindex=my_data.find('\n',index);
		if (newindex==-1) //no more \n's
		{
			remainder=my_data.right(my_data.length()-index);
			break;
		}
		else
		{
			lines.append(my_data.mid(index,newindex-index));
			index=newindex+1;
		}
	}
	//Now, we replace the incomplete last line,
	//with the first new one, this avoids a jerky movement.
	//debug ("lines.count-->%d",lines.count());
	//if (lines.count()>0)
	if (logViewer->count() > 0)
	{
		logViewer->changeItem(lines.first(),logViewer->count()-1);
		lines.remove((uint)0);
	}
	//put all the new lines we still got (if any) in the listbox
	//add the remainder at the bottom
	//and scroll so the last line is visible
	if (lines.count()>0)
		logViewer->insertStrList (&lines);
	logViewer->insertItem (remainder.data());
	logViewer->setTopItem(logViewer->count()-logViewer->numItemsVisible());
}


